/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.relic;

import io.github.lounode.extrabotany.common.advancements.ManaChargeTrigger;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.relic.RelicBaubleItem;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.xplat.XplatAbstractions;

public class MasterBandOfManaItem
extends RelicBaubleItem
implements CustomCreativeTabContents {
    protected static final long MAX_MANA = Long.MAX_VALUE;
    public static final long ADVANCEMENT_PHASE1_REQUIRE = Integer.MAX_VALUE;
    public static final long ADVANCEMENT_PHASE2_REQUIRE = Long.MAX_VALUE;
    private static final String TAG_MANA = "mana";

    public MasterBandOfManaItem(Item.Properties properties) {
        super(properties);
    }

    public void addToCreativeTab(Item me, CreativeModeTab.Output output) {
        output.m_246326_((ItemLike)this);
        ItemStack full = new ItemStack((ItemLike)this);
        MasterBandOfManaItem.setMana(full, Long.MAX_VALUE);
        output.m_246342_(full);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return Optional.of(new ManaBarTooltip(this.getFractionForDisplay(stack)));
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        tooltip.add((Component)Component.m_237113_((String)""));
        String manaString = this.getManaItem(stack).getRealMana() + "/" + this.getManaItem(stack).getRealMaxMana();
        tooltip.add((Component)Component.m_237110_((String)"message.extrabotany.actionbar.mana_left", (Object[])new Object[]{manaString}).m_130940_(ChatFormatting.GRAY));
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean held) {
        super.m_6883_(stack, world, entity, slot, held);
        if (!world.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null && relic.isRightPlayer(player) && player.f_19797_ % 10 == 0) {
                ExtendManaItemImpl manaItem = this.getManaItem(stack);
                ManaChargeTrigger.INSTANCE.trigger((ServerPlayer)player, stack, manaItem.getRealMana());
            }
        }
    }

    protected static void setMana(ItemStack stack, long mana) {
        if (mana > 0L) {
            ItemNBTHelper.setLong((ItemStack)stack, (String)TAG_MANA, (long)mana);
        } else {
            ItemNBTHelper.removeEntry((ItemStack)stack, (String)TAG_MANA);
        }
    }

    public static Relic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, ResourceLocationHelper.prefix("panda_do_not_wear_rings"));
    }

    public boolean m_142522_(ItemStack stack) {
        return false;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * this.getFractionForDisplay(stack));
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)(this.getFractionForDisplay(stack) / 3.0f), (float)1.0f, (float)1.0f);
    }

    private ExtendManaItemImpl getManaItem(ItemStack stack) {
        return (ExtendManaItemImpl)XplatAbstractions.INSTANCE.findManaItem(stack);
    }

    private float getFractionForDisplay(ItemStack stack) {
        long mana = this.getManaItem(stack).getRealMana();
        long max = this.getManaItem(stack).getRealMaxMana();
        return (float)mana / (float)max;
    }

    public static class ExtendManaItemImpl
    implements ManaItem {
        protected final ItemStack stack;

        public ExtendManaItemImpl(ItemStack stack) {
            this.stack = stack;
        }

        public int getMana() {
            int maxCharge;
            long mana = this.getRealMana();
            if (mana > (long)(Integer.MAX_VALUE - (maxCharge = 100000000))) {
                if (mana < Long.MAX_VALUE - (long)maxCharge) {
                    return Integer.MAX_VALUE - maxCharge;
                }
                return Integer.MAX_VALUE - (int)(this.getRealMaxMana() - mana);
            }
            return (int)mana;
        }

        public long getRealMana() {
            return ItemNBTHelper.getLong((ItemStack)this.stack, (String)MasterBandOfManaItem.TAG_MANA, (long)0L);
        }

        public int getMaxMana() {
            return Integer.MAX_VALUE;
        }

        public long getRealMaxMana() {
            return Long.MAX_VALUE;
        }

        public void addMana(int mana) {
            long current = this.getRealMana();
            if (mana > 0) {
                long maxAdd = Long.MAX_VALUE - current;
                current = (long)mana > maxAdd ? Long.MAX_VALUE : current + (long)mana;
            } else if (mana < 0) {
                long minSub = current - Long.MIN_VALUE;
                current = (long)(-mana) > minSub ? current + (long)mana : Long.MIN_VALUE;
            }
            long realMax = this.getRealMaxMana();
            long clamped = current < 0L ? 0L : Math.min(current, realMax);
            MasterBandOfManaItem.setMana(this.stack, clamped);
        }

        public boolean canReceiveManaFromPool(BlockEntity pool) {
            return true;
        }

        public boolean canReceiveManaFromItem(ItemStack otherStack) {
            return true;
        }

        public boolean canExportManaToPool(BlockEntity pool) {
            return true;
        }

        public boolean canExportManaToItem(ItemStack otherStack) {
            return true;
        }

        public boolean isNoExport() {
            return false;
        }
    }
}

