/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.relic.void_archives;

import io.github.lounode.extrabotany.api.ExtraBotanyAPI;
import io.github.lounode.extrabotany.api.item.VoidArchivesVariant;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.item.relic.void_archives.variants.Camera;
import io.github.lounode.extrabotany.common.item.relic.void_archives.variants.Excalibur;
import io.github.lounode.extrabotany.common.item.relic.void_archives.variants.Failnaught;
import io.github.lounode.extrabotany.common.item.relic.void_archives.variants.FruitOfGrisaia;
import io.github.lounode.extrabotany.common.item.relic.void_archives.variants.InfiniteWine;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.xplat.XplatAbstractions;

public class VoidArchivesItem
extends Item
implements CustomCreativeTabContents {
    private static final String TAG_VARIANT = "variant";
    public static final int KEEP_VARIANT_REQUIRE = 500;

    public VoidArchivesItem(Item.Properties properties) {
        super(properties);
        ExtraBotanyAPI.instance().registerVoidArchivesVariant(VoidArchivesVariant.DEFAULT);
        ExtraBotanyAPI.instance().registerVoidArchivesVariant(FruitOfGrisaia.INSTANCE);
        ExtraBotanyAPI.instance().registerVoidArchivesVariant(InfiniteWine.INSTANCE);
        ExtraBotanyAPI.instance().registerVoidArchivesVariant(Excalibur.INSTANCE);
        ExtraBotanyAPI.instance().registerVoidArchivesVariant(Failnaught.INSTANCE);
        ExtraBotanyAPI.instance().registerVoidArchivesVariant(Camera.INSTANCE);
    }

    public void addToCreativeTab(Item item, CreativeModeTab.Output output) {
        output.m_246342_(VoidArchivesItem.getDefaultItemStack());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (player.m_6144_()) {
            VoidArchivesItem.switchVariant(stack);
            return super.m_7203_(level, player, usedHand);
        }
        return VoidArchivesItem.getVariant(stack).use(level, player, usedHand);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        RelicImpl.addDefaultTooltip((ItemStack)stack, tooltipComponents);
        VoidArchivesItem.getVariant(stack).appendHoverText(stack, level, tooltipComponents, isAdvanced);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null) {
                relic.tickBinding(player);
            }
            if (VoidArchivesItem.getVariant(stack) != VoidArchivesVariant.DEFAULT && !ManaItemHandler.instance().requestManaExactForTool(stack, player, this.getKeepVariantRequire(), true)) {
                VoidArchivesItem.setVariant(stack, VoidArchivesVariant.DEFAULT);
            }
        }
        super.m_6883_(stack, level, entity, slotId, isSelected);
        VoidArchivesItem.getVariant(stack).inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public static void switchVariant(ItemStack stack) {
        if (!(stack.m_41720_() instanceof VoidArchivesItem)) {
            return;
        }
        Map<String, VoidArchivesVariant> variants = ExtraBotanyAPI.instance().getVoidArchivesVariants();
        VoidArchivesVariant current = VoidArchivesItem.getVariant(stack);
        int index = new ArrayList<String>(variants.keySet()).indexOf(current.getId());
        int nextIndex = (index + 1) % variants.size();
        String nextKey = new ArrayList<String>(variants.keySet()).get(nextIndex);
        VoidArchivesVariant nextVariant = variants.get(nextKey);
        VoidArchivesItem.setVariant(stack, nextVariant);
    }

    public static void setVariant(ItemStack stack, VoidArchivesVariant variant) {
        if (!(stack.m_41720_() instanceof VoidArchivesItem)) {
            return;
        }
        VoidArchivesVariant current = VoidArchivesItem.getVariant(stack);
        current.onInactive(stack);
        ItemNBTHelper.setString((ItemStack)stack, (String)TAG_VARIANT, (String)variant.getId());
        variant.onActive(stack);
    }

    public static VoidArchivesVariant getVariant(ItemStack stack) {
        String variantString = ItemNBTHelper.getString((ItemStack)stack, (String)TAG_VARIANT, (String)VoidArchivesVariant.DEFAULT.getId());
        return ExtraBotanyAPI.instance().getVoidArchivesVariants().getOrDefault(variantString, VoidArchivesVariant.DEFAULT);
    }

    public static String getTagVariant(ItemStack stack) {
        return ItemNBTHelper.getString((ItemStack)stack, (String)TAG_VARIANT, (String)VoidArchivesVariant.DEFAULT.getId());
    }

    public static int getVariantIndex(ItemStack stack) {
        if (!(stack.m_41720_() instanceof VoidArchivesItem)) {
            return -1;
        }
        Map<String, VoidArchivesVariant> variants = ExtraBotanyAPI.instance().getVoidArchivesVariants();
        VoidArchivesVariant current = VoidArchivesItem.getVariant(stack);
        return new ArrayList<String>(variants.keySet()).indexOf(current.getId());
    }

    public static ItemStack getDefaultItemStack() {
        ItemStack defaultStack = new ItemStack((ItemLike)ExtraBotanyItems.voidArchives);
        ItemNBTHelper.setString((ItemStack)defaultStack, (String)TAG_VARIANT, (String)VoidArchivesVariant.DEFAULT.getId());
        return defaultStack;
    }

    public int getKeepVariantRequire() {
        return 500;
    }

    public ItemStack m_7968_() {
        return VoidArchivesItem.getDefaultItemStack();
    }

    public static Relic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, ResourceLocationHelper.prefix("the_original_divine_key"));
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        super.m_5929_(level, livingEntity, stack, remainingUseDuration);
        VoidArchivesItem.getVariant(stack).onUseTick(level, livingEntity, stack, remainingUseDuration);
    }

    public void m_142023_(ItemEntity itemEntity) {
        super.m_142023_(itemEntity);
        VoidArchivesItem.getVariant(itemEntity.m_32055_()).onDestroyed(itemEntity);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return VoidArchivesItem.getVariant(context.m_43722_()).useOn(context);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return VoidArchivesItem.getVariant(stack).getDestroySpeed(stack, state);
    }

    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity livingEntity) {
        return VoidArchivesItem.getVariant(stack).finishUsingItem(stack, level, livingEntity);
    }

    public boolean m_142305_(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        return VoidArchivesItem.getVariant(stack).overrideOtherStackedOnMe(stack, other, slot, action, player, access);
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        return VoidArchivesItem.getVariant(stack).overrideStackedOnOther(stack, slot, action, player);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return VoidArchivesItem.getVariant(stack).hurtEnemy(stack, target, attacker);
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        return VoidArchivesItem.getVariant(stack).mineBlock(stack, level, state, pos, miningEntity);
    }

    public int m_8105_(ItemStack stack) {
        return VoidArchivesItem.getVariant(stack).getUseDuration(stack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return VoidArchivesItem.getVariant(stack).getUseAnimation(stack);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        VoidArchivesItem.getVariant(stack).releaseUsing(stack, level, livingEntity, timeCharged);
    }

    public boolean m_41463_(ItemStack stack) {
        return VoidArchivesItem.getVariant(stack).useOnRelease(stack);
    }
}

