/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.telemetry;

import com.google.gson.JsonObject;
import io.github.lounode.eventwrapper.event.server.ServerStartedEventWrapper;
import io.github.lounode.eventwrapper.event.server.ServerStoppingEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.common.entity.gaia.Gaia;
import io.github.lounode.extrabotany.common.entity.gaia.GaiaIII;
import io.github.lounode.extrabotany.common.telemetry.Metrics;
import io.github.lounode.extrabotany.common.telemetry.MetricsNew;
import io.github.lounode.extrabotany.common.telemetry.TelemetryProperty;
import io.github.lounode.extrabotany.common.telemetry.TelemetryPropertyMap;
import io.github.lounode.extrabotany.common.telemetry.charts.SimplePie;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.UUID;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.Difficulty;

@EventBusSubscriberWrapper
public class ExtraBotanyTelemetry {
    private static ExtraBotanyTelemetry INSTANCE;
    private final int serviceId = 25178;
    private Metrics metrics;
    private final TelemetryPropertyMap deviceSessionProperties;
    private MetricsNew metricsNew;

    public static ExtraBotanyTelemetry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExtraBotanyTelemetry();
        }
        return INSTANCE;
    }

    private ExtraBotanyTelemetry() {
        TelemetryPropertyMap.Builder builder = TelemetryPropertyMap.builder();
        builder.put(TelemetryProperty.GAME_VERSION, SharedConstants.m_183709_().m_132492_());
        builder.put(TelemetryProperty.OS_NAME, Util.m_137581_().m_183999_());
        builder.put(TelemetryProperty.OS_ARCH, System.getProperty("os.arch"));
        builder.put(TelemetryProperty.OS_VERSION, System.getProperty("os.version"));
        builder.put(TelemetryProperty.JAVA_VERSION, System.getProperty("java.version"));
        builder.put(TelemetryProperty.CORE_COUNT, Runtime.getRuntime().availableProcessors());
        builder.put(TelemetryProperty.MOD_LOADER, EXplatAbstractions.INSTANCE.getModLoader());
        builder.put(TelemetryProperty.MOD_SERVICE_ID, 25178);
        builder.put(TelemetryProperty.MOD_VERSION, EXplatAbstractions.INSTANCE.getExtraBotanyVersion());
        this.deviceSessionProperties = builder.build();
    }

    @SubscribeEventWrapper
    public static void onServerStarted(ServerStartedEventWrapper event) {
        MinecraftServer server = event.getServer();
        boolean enableTelemetry = ExtraBotanyConfig.common().enableTelemetry();
        if (!enableTelemetry) {
            return;
        }
        String telemetryUUID = ExtraBotanyConfig.common().telemetryUUID();
        ExtraBotanyTelemetry.getInstance().metrics = new Metrics("sponge", telemetryUUID, ExtraBotanyTelemetry.getInstance().serviceId, ExtraBotanyTelemetry.appendPlatformData(server), ExtraBotanyTelemetry.appendServiceData(), server);
        ExtraBotanyTelemetry.getInstance().metrics.addCustomChart(new SimplePie("modLoader", () -> EXplatAbstractions.INSTANCE.isForge() ? "forge" : "fabric"));
        ExtraBotanyTelemetry.getInstance().metrics.addCustomChart(new SimplePie("serverType", () -> server.m_6982_() ? TelemetryProperty.ServerType.OTHER.m_7912_() : TelemetryProperty.ServerType.LOCAL.m_7912_()));
        MetricsNew metricsNew = ExtraBotanyTelemetry.getInstance().metricsNew;
        if (metricsNew != null) {
            metricsNew.shutdown();
            ExtraBotanyTelemetry.getInstance().metricsNew = null;
        }
        ExtraBotanyTelemetry.getInstance().metricsNew = new MetricsNew(ExtraBotanyTelemetry.getInstance().deviceSessionProperties, MetricsNew.getServerUUID(server, UUID.fromString(telemetryUUID)), server);
        ExtraBotanyTelemetry.getInstance().metricsNew.start();
    }

    @SubscribeEventWrapper
    public static void onServerStopping(ServerStoppingEventWrapper event) {
        MetricsNew metricsNew = ExtraBotanyTelemetry.getInstance().metricsNew;
        if (metricsNew != null) {
            metricsNew.shutdown();
            ExtraBotanyTelemetry.getInstance().metricsNew = null;
        }
    }

    private static JsonObject appendPlatformData(MinecraftServer server) {
        JsonObject builder = new JsonObject();
        builder.addProperty("onlineMode", (Number)(server.m_129797_() ? 1 : 0));
        builder.addProperty("minecraftVersion", server.m_7630_());
        builder.addProperty("javaVersion", System.getProperty("java.version"));
        builder.addProperty("osName", System.getProperty("os.name"));
        builder.addProperty("osArch", System.getProperty("os.arch"));
        builder.addProperty("osVersion", System.getProperty("os.version"));
        builder.addProperty("coreCount", (Number)Runtime.getRuntime().availableProcessors());
        return builder;
    }

    private static JsonObject appendServiceData() {
        JsonObject builder = new JsonObject();
        builder.addProperty("pluginVersion", EXplatAbstractions.INSTANCE.getExtraBotanyVersion());
        return builder;
    }

    public static class Event {
        public static void onGaiaBattleFinish(Gaia gaia) {
            if (((Object)((Object)gaia)).getClass() != GaiaIII.class) {
                return;
            }
            String status = gaia.m_21223_() <= 0.0f ? "success" : "failed";
            double health = gaia.m_21223_();
            int playerCount = gaia.getPlayerCount();
            Difficulty difficulty = gaia.m_9236_().m_46791_();
            int durationTicks = gaia.f_19797_;
            if (playerCount < 1 || playerCount > 20) {
                return;
            }
            if (difficulty == Difficulty.PEACEFUL) {
                return;
            }
            if (durationTicks < 200) {
                return;
            }
            JsonObject data = new JsonObject();
            data.addProperty("status", status);
            data.addProperty("healthRemain", (Number)health);
            data.addProperty("playerCount", (Number)playerCount);
            data.addProperty("difficulty", difficulty.m_19036_());
            data.addProperty("duration", (Number)durationTicks);
        }
    }
}

