/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.telemetry.charts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lounode.extrabotany.common.telemetry.charts.Chart;
import java.util.Map;
import java.util.concurrent.Callable;

public class DrilldownPie
extends Chart {
    private final Callable<Map<String, Map<String, Integer>>> callable;

    public DrilldownPie(String chartId, Callable<Map<String, Map<String, Integer>>> callable) {
        super(chartId);
        this.callable = callable;
    }

    @Override
    protected JsonObject getChartData() throws Exception {
        Map<String, Map<String, Integer>> map = this.callable.call();
        if (map == null || map.isEmpty()) {
            return null;
        }
        JsonObject data = new JsonObject();
        JsonObject values = new JsonObject();
        boolean reallyAllSkipped = true;
        for (Map.Entry<String, Map<String, Integer>> entryValues : map.entrySet()) {
            JsonObject value = new JsonObject();
            boolean allSkipped = true;
            for (Map.Entry<String, Integer> valueEntry : map.get(entryValues.getKey()).entrySet()) {
                value.addProperty(valueEntry.getKey(), (Number)valueEntry.getValue());
                allSkipped = false;
            }
            if (allSkipped) continue;
            reallyAllSkipped = false;
            values.add(entryValues.getKey(), (JsonElement)value);
        }
        if (reallyAllSkipped) {
            return null;
        }
        data.add("values", (JsonElement)values);
        return data;
    }
}

