/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.util;

import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;

public class AttributeUtil {
    public static final DecimalFormat ATTRIBUTE_MODIFIER_FORMAT = (DecimalFormat)Util.m_137469_((Object)new DecimalFormat("#.##"), format -> format.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT)));

    public static void addAttributeModifier(ItemStack stack, Attribute attribute, AttributeModifier modifier, @Nullable EquipmentSlot slot) {
        stack.m_41784_();
        if (!stack.m_41783_().m_128425_("AttributeModifiers", 9)) {
            stack.m_41783_().m_128365_("AttributeModifiers", (Tag)new ListTag());
        }
        ListTag listtag = stack.m_41783_().m_128437_("AttributeModifiers", 10);
        CompoundTag compoundtag = modifier.m_22219_();
        compoundtag.m_128359_("AttributeName", BuiltInRegistries.f_256951_.m_7981_((Object)attribute).toString());
        if (slot != null) {
            compoundtag.m_128359_("Slot", slot.m_20751_());
        }
        listtag.add((Object)compoundtag);
    }

    public static void removeAttributeModifier(ItemStack stack, String modifierName) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_("AttributeModifiers", 9)) {
            return;
        }
        ListTag modifiers = tag.m_128437_("AttributeModifiers", 10);
        ListTag newModifiers = new ListTag();
        for (Tag t : modifiers) {
            CompoundTag modifier = (CompoundTag)t;
            if (modifier.m_128461_("Name").equals(modifierName)) continue;
            newModifiers.add((Object)modifier);
        }
        if (newModifiers.size() != modifiers.size()) {
            tag.m_128365_("AttributeModifiers", (Tag)newModifiers);
        }
        if (newModifiers.isEmpty()) {
            tag.m_128473_("AttributeModifiers");
        }
    }

    public static List<Component> getTooltips(Multimap<Attribute, AttributeModifier> multimap) {
        ArrayList<Component> list = new ArrayList<Component>();
        for (Map.Entry entry : multimap.entries()) {
            AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
            double d0 = attributemodifier.m_22218_();
            boolean flag = false;
            double d1 = attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (((Attribute)entry.getKey()).equals(Attributes.f_22278_) ? d0 * 10.0 : d0) : d0 * 100.0;
            if (d0 > 0.0) {
                list.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                continue;
            }
            if (!(d0 < 0.0)) continue;
            list.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ATTRIBUTE_MODIFIER_FORMAT.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.RED));
        }
        return list;
    }
}

