/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data;

import io.github.lounode.extrabotany.common.block.ExtraBotanyBlocks;
import io.github.lounode.extrabotany.common.block.PedestalBlock;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.mixin.BlockModelGeneratorsAccessor;

public class BlockstateProvider
extends vazkii.botania.data.BlockstateProvider {
    public BlockstateProvider(PackOutput packOutput) {
        super(packOutput);
    }

    @NotNull
    public String m_6055_() {
        return "ExtraBotany Blockstates and Models";
    }

    protected void registerStatesAndModels() {
        Set<Block> remainingBlocks = BuiltInRegistries.f_256975_.m_123024_().filter(b -> "extrabotany".equals(BuiltInRegistries.f_256975_.m_7981_(b).m_135827_())).collect(Collectors.toSet());
        this.manualModel(remainingBlocks, ExtraBotanyBlocks.manaCharger);
        this.manualModel(remainingBlocks, ExtraBotanyBlocks.powerFrame);
        ModelTemplate pedestalTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/pedestal")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125872_, TextureSlot.f_125880_, TextureSlot.f_125881_, TextureSlot.f_125875_, TextureSlot.f_125869_});
        this.takeAll(remainingBlocks, b -> b instanceof PedestalBlock).forEach(b -> this.singleVariantBlockState((Block)b, pedestalTemplate.m_125592_(b, new TextureMapping().m_125758_(TextureSlot.f_125872_, TextureMapping.m_125753_((Block)b, (String)"_top")).m_125758_(TextureSlot.f_125880_, TextureMapping.m_125753_((Block)b, (String)"_up")).m_125758_(TextureSlot.f_125881_, TextureMapping.m_125753_((Block)b, (String)"_down")).m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)b, (String)"_side")).m_125758_(TextureSlot.f_125869_, TextureMapping.m_125753_((Block)b, (String)"_down")), this.modelOutput)));
        for (String variant : new String[]{"gaia", "elementium"}) {
            ResourceLocation quartzId = ResourceLocationHelper.prefix(variant + "_quartz_block");
            Block quartz = (Block)BuiltInRegistries.f_256975_.m_7745_(quartzId);
            this.singleVariantBlockState(quartz, ModelTemplates.f_125697_.m_125592_(quartz, TextureMapping.m_125826_((Block)quartz), this.modelOutput));
            ResourceLocation pillarId = ResourceLocationHelper.prefix(variant + "_quartz_pillar");
            Block pillar = (Block)BuiltInRegistries.f_256975_.m_7745_(pillarId);
            ResourceLocation pillarModel = ModelTemplates.f_125694_.m_125592_(pillar, TextureMapping.m_125763_((ResourceLocation)TextureMapping.m_125753_((Block)pillar, (String)""), (ResourceLocation)TextureMapping.m_125753_((Block)pillar, (String)"_top")), this.modelOutput);
            this.blockstates.add(BlockModelGeneratorsAccessor.createAxisAlignedPillarBlock((Block)pillar, (ResourceLocation)pillarModel));
            ResourceLocation chiseledId = ResourceLocationHelper.prefix("chiseled_" + variant + "_quartz_block");
            Block chiseled = (Block)BuiltInRegistries.f_256975_.m_7745_(chiseledId);
            this.singleVariantBlockState(chiseled, ModelTemplates.f_125694_.m_125592_(chiseled, new TextureMapping().m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)chiseled, (String)"")).m_125758_(TextureSlot.f_125870_, TextureMapping.m_125753_((Block)chiseled, (String)"_top")), this.modelOutput));
            ResourceLocation bricksId = ResourceLocationHelper.prefix(variant + "_quartz_bricks");
            Block bricks = (Block)BuiltInRegistries.f_256975_.m_7745_(bricksId);
            this.singleVariantBlockState(bricks, ModelTemplates.f_125692_.m_125592_(bricks, TextureMapping.m_125748_((Block)bricks), this.modelOutput));
            ResourceLocation smoothId = ResourceLocationHelper.prefix("smooth_" + variant + "_quartz");
            Block smooth = (Block)BuiltInRegistries.f_256975_.m_7745_(smoothId);
            this.singleVariantBlockState(smooth, ModelTemplates.f_125692_.m_125592_(smooth, TextureMapping.m_125776_((ResourceLocation)ResourceLocationHelper.prefix("block/" + variant + "_quartz_block_bottom")), this.modelOutput));
            remainingBlocks.remove(quartz);
            remainingBlocks.remove(pillar);
            remainingBlocks.remove(chiseled);
            remainingBlocks.remove(bricks);
            remainingBlocks.remove(smooth);
        }
        this.takeAll(remainingBlocks, b -> b instanceof StairBlock).forEach(b -> {
            String name = BuiltInRegistries.f_256975_.m_7981_(b).m_135815_();
            Object baseName = name.substring(0, name.length() - "_stairs".length());
            boolean quartz = name.contains("quartz");
            if (quartz) {
                baseName = (String)baseName + "_block";
                ResourceLocation side = ResourceLocationHelper.prefix("block/" + (String)baseName + "_side");
                ResourceLocation top = ResourceLocationHelper.prefix("block/" + (String)baseName + "_top");
                boolean smooth = name.contains("smooth");
                if (!smooth) {
                    this.stairsBlock(new HashSet(), (Block)b, side, top, top);
                } else {
                    ResourceLocation bottom = ResourceLocationHelper.prefix("block/" + ((String)baseName).replace("smooth_", "") + "_bottom");
                    this.stairsBlock(new HashSet(), (Block)b, bottom, bottom, bottom);
                }
            } else {
                ResourceLocation tex = ResourceLocationHelper.prefix("block/" + (String)baseName);
                this.stairsBlock(new HashSet(), (Block)b, tex, tex, tex);
            }
        });
        this.takeAll(remainingBlocks, b -> b instanceof SlabBlock).forEach(slabBlock -> {
            String name = BuiltInRegistries.f_256975_.m_7981_(slabBlock).m_135815_();
            String baseName = name.substring(0, name.length() - "_slab".length());
            Block base = (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocationHelper.prefix(baseName));
            boolean quartz = name.contains("quartz");
            if (quartz) {
                base = (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocationHelper.prefix(baseName.replace("smooth_", "") + "_block"));
                ResourceLocation side = TextureMapping.m_125753_((Block)base, (String)"_side");
                ResourceLocation bottom = TextureMapping.m_125753_((Block)base, (String)"_bottom");
                ResourceLocation top = TextureMapping.m_125753_((Block)base, (String)"_top");
                ResourceLocation doubleModel = ModelLocationUtils.m_125576_((Block)base);
                boolean smooth = name.contains("smooth");
                if (!smooth) {
                    this.slabBlock(new HashSet(), (Block)slabBlock, doubleModel, side, top, top);
                } else {
                    this.slabBlock(new HashSet(), (Block)slabBlock, doubleModel, bottom, bottom, bottom);
                }
            } else {
                ResourceLocation baseTex = TextureMapping.m_125740_((Block)base);
                ResourceLocation doubleModel = ModelLocationUtils.m_125576_((Block)base);
                this.slabBlock(new HashSet(), (Block)slabBlock, doubleModel, baseTex, baseTex, baseTex);
            }
        });
        Predicate<Block> flowers = arg_0 -> ((EXplatAbstractions)EXplatAbstractions.INSTANCE).isSpecialFlowerBlock(arg_0);
        ModelTemplate crossTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefixBotania("block/shapes/cross")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125882_});
        this.takeAll(remainingBlocks, flowers).forEach(b -> this.singleVariantBlockState((Block)b, crossTemplate.m_125592_(b, TextureMapping.m_125780_((Block)b), this.modelOutput)));
        this.takeAll(remainingBlocks, b -> b instanceof FloatingFlowerBlock).forEach(b -> this.singleVariantBlockState((Block)b, ModelLocationUtils.m_125576_((Block)b)));
        remainingBlocks.forEach(x$0 -> this.cubeAllNoRemove((Block)x$0));
    }
}

