/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.xplat.ClientXplatAbstractions;

public class FloatingFlowerModelProvider
implements DataProvider {
    private final PackOutput packOutput;

    public FloatingFlowerModelProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        ArrayList<Tuple> jsons = new ArrayList<Tuple>();
        for (Block b : BuiltInRegistries.f_256975_) {
            ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)b);
            if (!"extrabotany".equals(id.m_135827_()) || !(b instanceof FloatingFlowerBlock)) continue;
            String name = id.m_135815_();
            String nonFloat = name.endsWith("_floating_flower") ? name.replace("_floating_flower", "_mystical_flower") : name.replace("floating_", "");
            JsonObject obj = new JsonObject();
            obj.addProperty("parent", "minecraft:block/block");
            obj.addProperty("loader", ClientXplatAbstractions.FLOATING_FLOWER_MODEL_LOADER_ID.toString());
            JsonObject flower = new JsonObject();
            flower.addProperty("parent", "extrabotany:block/" + nonFloat);
            obj.add("flower", (JsonElement)flower);
            jsons.add(new Tuple((Object)name, (Object)obj));
        }
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>();
        PackOutput.PathProvider blocks = this.packOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "models/block");
        PackOutput.PathProvider items = this.packOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "models/item");
        for (Tuple pair : jsons) {
            output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((JsonElement)pair.m_14419_()), (Path)blocks.m_245731_(ResourceLocationHelper.prefix((String)pair.m_14418_()))));
            output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((JsonElement)pair.m_14419_()), (Path)items.m_245731_(ResourceLocationHelper.prefix((String)pair.m_14418_()))));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    public String m_6055_() {
        return "Extrabotany floating flower models";
    }
}

