/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import org.jetbrains.annotations.NotNull;

public class PottedPlantModelProvider
implements DataProvider {
    private final PackOutput packOutput;

    public PottedPlantModelProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        ArrayList<Tuple> jsons = new ArrayList<Tuple>();
        for (Block b : BuiltInRegistries.f_256975_) {
            ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)b);
            if (!"extrabotany".equals(blockId.m_135827_()) || !(b instanceof FlowerPotBlock)) continue;
            String name = blockId.m_135815_();
            String nonPotted = name.replace("potted_", "").replace("_motif", "");
            JsonObject obj = new JsonObject();
            obj.addProperty("parent", "minecraft:block/flower_pot_cross");
            JsonObject textures = new JsonObject();
            textures.addProperty("plant", "extrabotany:block/" + nonPotted);
            obj.add("textures", (JsonElement)textures);
            jsons.add(new Tuple((Object)name, (Object)obj));
        }
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>();
        PackOutput.PathProvider blocks = this.packOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "models/block");
        for (Tuple pair : jsons) {
            output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((JsonElement)pair.m_14419_()), (Path)blocks.m_245731_(ResourceLocationHelper.prefix((String)pair.m_14418_()))));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    static MultiVariantGenerator createSimpleBlock(Block block, ResourceLocation resourceLocation) {
        return MultiVariantGenerator.m_125256_((Block)block, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)resourceLocation));
    }

    @NotNull
    public String m_6055_() {
        return "Extrabotany potted plant models";
    }
}

