/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data;

import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import io.github.lounode.extrabotany.data.sound.SoundDefinition;
import io.github.lounode.extrabotany.data.sound.SoundDefinitionsProvider;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import vazkii.botania.common.handler.BotaniaSounds;

public class SoundProvider
extends SoundDefinitionsProvider {
    public SoundProvider(PackOutput output, String modId) {
        super(output, modId);
    }

    @Override
    public void registerSounds() {
        Set<SoundEvent> soundEvents = BuiltInRegistries.f_256894_.m_123024_().filter(i -> "extrabotany".equals(BuiltInRegistries.f_256894_.m_7981_(i).m_135827_())).collect(Collectors.toSet());
        this.take(soundEvents, ExtraBotanySounds.EXCALIBUR_ATTACK);
        this.take(soundEvents, ExtraBotanySounds.FAILNAUGHT_SHOOT);
        this.take(soundEvents, ExtraBotanySounds.FEATHER_OF_JINGWEI_SHOOT);
        this.take(soundEvents, ExtraBotanySounds.PLAYER_BACKFIRE);
        this.take(soundEvents, ExtraBotanySounds.MUSIC_GAIA3);
        this.take(soundEvents, ExtraBotanySounds.REWARD_BAG_OPEN);
        this.take(soundEvents, ExtraBotanySounds.PANDORAS_BOX_OPEN);
        this.add(ExtraBotanySounds.PANDORAS_BOX_OPEN, SoundDefinitionsProvider.definition().subtitle(this.title(ExtraBotanySounds.PANDORAS_BOX_OPEN)).with(SoundDefinitionsProvider.sound(SoundEvents.f_11672_.m_11660_(), SoundDefinition.SoundType.EVENT)));
        this.add(ExtraBotanySounds.REWARD_BAG_OPEN, SoundDefinitionsProvider.definition().subtitle(this.title(ExtraBotanySounds.REWARD_BAG_OPEN)).with(SoundDefinitionsProvider.sound(SoundEvents.f_11678_.m_11660_(), SoundDefinition.SoundType.EVENT)));
        this.add(ExtraBotanySounds.EXCALIBUR_ATTACK, SoundDefinitionsProvider.definition().subtitle(this.title(ExtraBotanySounds.EXCALIBUR_ATTACK)).with(SoundDefinitionsProvider.sound(BotaniaSounds.terraBlade.m_11660_()).volume(0.4f).pitch(1.4f)));
        this.add(ExtraBotanySounds.FAILNAUGHT_SHOOT, SoundDefinitionsProvider.definition().subtitle(this.title(ExtraBotanySounds.FAILNAUGHT_SHOOT)).with(SoundDefinitionsProvider.sound(BotaniaSounds.terraBlade.m_11660_()).volume(0.4f).pitch(1.4f)));
        this.add(ExtraBotanySounds.FEATHER_OF_JINGWEI_SHOOT, SoundDefinitionsProvider.definition().subtitle(this.title(ExtraBotanySounds.FEATHER_OF_JINGWEI_SHOOT)).with(SoundDefinitionsProvider.sound(SoundEvents.f_11937_.m_11660_(), SoundDefinition.SoundType.EVENT).volume(0.2f)));
        this.add(ExtraBotanySounds.PLAYER_BACKFIRE, SoundDefinitionsProvider.definition().subtitle(this.title(ExtraBotanySounds.PLAYER_BACKFIRE)).with(SoundDefinitionsProvider.sound(SoundEvents.f_144205_.m_11660_(), SoundDefinition.SoundType.EVENT)));
        this.add(ExtraBotanySounds.MUSIC_GAIA3, SoundDefinitionsProvider.definition().with(SoundDefinitionsProvider.sound(this.relocateOggPath(ExtraBotanySounds.MUSIC_GAIA3.m_11660_())).stream().volume(1.3f)));
        this.take(soundEvents, ExtraBotanySounds.WALKING_CANE_USE);
        this.add(ExtraBotanySounds.WALKING_CANE_USE, SoundDefinitionsProvider.definition().subtitle(this.title(ExtraBotanySounds.WALKING_CANE_USE)).with(SoundDefinitionsProvider.sound(SoundEvents.f_11939_.m_11660_(), SoundDefinition.SoundType.EVENT)));
        this.take(soundEvents, ExtraBotanySounds.ARMOR_EQUIP_MAID);
        this.add(ExtraBotanySounds.ARMOR_EQUIP_MAID, SoundDefinition.definition().subtitle(this.title(ExtraBotanySounds.ARMOR_EQUIP_MAID)).with(SoundDefinitionsProvider.sound(BotaniaSounds.equipManaweave.m_11660_(), SoundDefinition.SoundType.EVENT)));
        this.take(soundEvents, ExtraBotanySounds.ARMOR_EQUIP_IDOL);
        this.add(ExtraBotanySounds.ARMOR_EQUIP_IDOL, SoundDefinition.definition().subtitle(this.title(ExtraBotanySounds.ARMOR_EQUIP_IDOL)).with(SoundDefinitionsProvider.sound(BotaniaSounds.equipManaweave.m_11660_(), SoundDefinition.SoundType.EVENT)));
        this.take(soundEvents, ExtraBotanySounds.HAMMER_USE);
        this.add(ExtraBotanySounds.HAMMER_USE, SoundDefinition.definition().subtitle(this.title(ExtraBotanySounds.HAMMER_USE)).with(SoundDefinitionsProvider.sound(BotaniaSounds.terraPickMode.m_11660_(), SoundDefinition.SoundType.EVENT)));
        this.take(soundEvents, ExtraBotanySounds.ARMOR_EQUIP_GOBLIN);
        this.add(ExtraBotanySounds.ARMOR_EQUIP_GOBLIN, SoundDefinition.definition().subtitle(this.title(ExtraBotanySounds.ARMOR_EQUIP_GOBLIN)).with(SoundDefinitionsProvider.sound(SoundEvents.f_11677_.m_11660_(), SoundDefinition.SoundType.EVENT)));
        this.take(soundEvents, ExtraBotanySounds.ARMOR_EQUIP_WARRIOR);
        this.add(ExtraBotanySounds.ARMOR_EQUIP_WARRIOR, SoundDefinition.definition().subtitle(this.title(ExtraBotanySounds.ARMOR_EQUIP_WARRIOR)).with(SoundDefinitionsProvider.sound(SoundEvents.f_11672_.m_11660_(), SoundDefinition.SoundType.EVENT)));
        for (SoundEvent soundEvent : soundEvents) {
            this.add(soundEvent, this.defaultDefinition(soundEvent));
        }
    }

    public String title(SoundEvent soundEvent) {
        return "subtitles." + String.valueOf(soundEvent.m_11660_());
    }

    protected void take(Set<SoundEvent> form, SoundEvent soundEvent) {
        form.remove(soundEvent);
    }

    protected SoundDefinition copyDefinition(SoundEvent soundEvent, SoundEvent ... copyFrom) {
        SoundDefinition definition = SoundDefinitionsProvider.definition().subtitle("subtitles." + String.valueOf(soundEvent.m_11660_()));
        for (SoundEvent sound : copyFrom) {
            definition.with(SoundDefinitionsProvider.sound(sound.m_11660_()));
        }
        return definition;
    }

    protected SoundDefinition defaultDefinition(SoundEvent soundEvent) {
        return SoundDefinitionsProvider.definition().subtitle("subtitles." + String.valueOf(soundEvent.m_11660_())).with(SoundDefinitionsProvider.sound(this.relocateOggPath(soundEvent.m_11660_())));
    }

    protected ResourceLocation relocateOggPath(ResourceLocation location) {
        String namespace = location.m_135827_();
        String originPath = location.m_135815_();
        String path = originPath.replace('.', '/');
        return ResourceLocation.m_214293_((String)namespace, (String)path);
    }
}

