/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data.loot;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;

public abstract class RewardBagLootSubProvider
implements LootTableSubProvider {
    private final Map<ResourceLocation, LootTable.Builder> map = Maps.newHashMap();

    protected RewardBagLootSubProvider() {
    }

    public abstract void generate();

    public abstract String getNameSpace();

    public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> output) {
        this.generate();
        HashSet duplicates = Sets.newHashSet();
        HashSet processed = Sets.newHashSet();
        for (Map.Entry<ResourceLocation, LootTable.Builder> entry : this.map.entrySet()) {
            ResourceLocation location2 = entry.getKey();
            if (processed.add(location2)) continue;
            duplicates.add(location2);
        }
        if (!duplicates.isEmpty()) {
            throw new IllegalStateException("Duplicate loot tables: " + String.valueOf(duplicates));
        }
        this.map.forEach((location, builder) -> {
            try {
                output.accept((ResourceLocation)location, (LootTable.Builder)builder);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create loot table '" + String.valueOf(location) + "'", e);
            }
        });
    }

    protected void add(ResourceLocation lootTableLocation, LootTable.Builder builder) {
        this.map.put(lootTableLocation, builder);
    }

    public void add(String key, LootTable.Builder builder) {
        ResourceLocation lootTableLocation = ResourceLocation.m_214293_((String)this.getNameSpace(), (String)key).m_246208_("reward_bags/");
        this.add(lootTableLocation, builder);
    }
}

