/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lounode.extrabotany.common.block.ExtraBotanyBlocks;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.data.recipes.ExtraBotanyRecipeProvider;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.helper.ItemNBTHelper;

public class ManaInfusionProvider
extends ExtraBotanyRecipeProvider {
    public ManaInfusionProvider(PackOutput packOutput) {
        super(packOutput);
    }

    public String m_6055_() {
        return "ExtraBotany mana pool recipes";
    }

    @Override
    public void buildRecipes(Consumer<net.minecraft.data.recipes.FinishedRecipe> consumer) {
        consumer.accept(new FinishedRecipe(this.id("nightmare_fuel"), new ItemStack((ItemLike)ExtraBotanyItems.nightmareFuel), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_}), 2000));
        consumer.accept(new FinishedRecipe(this.id("fried_chicken"), new ItemStack((ItemLike)ExtraBotanyItems.friedChicken), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42582_}), 600));
        consumer.accept(FinishedRecipe.dimension(this.id("snowball_to_ender_pearl"), new ItemStack((ItemLike)Items.f_42584_), ManaInfusionProvider.ingr((ItemLike)Items.f_42452_), 2000));
        consumer.accept(FinishedRecipe.dimension(this.id("diamond_horse_armor_to_shulker_shell"), new ItemStack((ItemLike)Items.f_42748_), ManaInfusionProvider.ingr((ItemLike)Items.f_42653_), 20000));
        consumer.accept(FinishedRecipe.dimension(this.id("apple_to_chorus_fruit"), new ItemStack((ItemLike)Items.f_42730_), ManaInfusionProvider.ingr((ItemLike)Items.f_42410_), 500));
        consumer.accept(FinishedRecipe.dimension(this.id("stone_to_end_stone"), new ItemStack((ItemLike)Items.f_42102_), ManaInfusionProvider.ingr((ItemLike)Items.f_41905_), 500));
        consumer.accept(FinishedRecipe.dimension(this.id("cobblestone_to_nether_rack"), new ItemStack((ItemLike)Items.f_42048_), ManaInfusionProvider.ingr((ItemLike)Items.f_42594_), 500));
        consumer.accept(FinishedRecipe.dimension(this.id("sand_to_soul_sand"), new ItemStack((ItemLike)Items.f_42049_), ManaInfusionProvider.ingr((ItemLike)Items.f_41830_), 500));
        consumer.accept(FinishedRecipe.dimension(this.id("iron_ore_to_quartz_ore"), new ItemStack((ItemLike)Items.f_42154_), ManaInfusionProvider.ingr((ItemLike)Items.f_41834_), 2000));
        consumer.accept(FinishedRecipe.dimension(this.id("blaze_rod_dupe"), new ItemStack((ItemLike)Items.f_42585_, 2), ManaInfusionProvider.ingr((ItemLike)Items.f_42585_), 2000));
        consumer.accept(FinishedRecipe.dimension(this.id("nether_star_to_totem_of_undying"), new ItemStack((ItemLike)Items.f_42747_), ManaInfusionProvider.ingr((ItemLike)Items.f_42686_), 50000));
        consumer.accept(FinishedRecipe.dimension(this.id("the_origin_to_elytra"), new ItemStack((ItemLike)Items.f_42741_), ManaInfusionProvider.ingr((ItemLike)ExtraBotanyItems.theOrigin), 50000));
        consumer.accept(this.mini((ItemLike)ExtrabotanyFlowerBlocks.necrofleurChibi, (ItemLike)ExtrabotanyFlowerBlocks.necrofleur));
    }

    protected void cycle(Consumer<net.minecraft.data.recipes.FinishedRecipe> consumer, int cost, String group, ItemLike ... items) {
        for (int i = 0; i < items.length; ++i) {
            Ingredient in = ManaInfusionProvider.ingr(items[i]);
            ItemStack out = new ItemStack(i == items.length - 1 ? items[0] : items[i + 1]);
            String id = String.format("%s_to_%s", BuiltInRegistries.f_257033_.m_7981_((Object)items[i].m_5456_()).m_135815_(), BuiltInRegistries.f_257033_.m_7981_((Object)out.m_41720_()).m_135815_());
            consumer.accept(FinishedRecipe.alchemy(this.id(id), out, in, cost, group));
        }
    }

    protected FinishedRecipe mini(ItemLike mini, ItemLike full) {
        return FinishedRecipe.alchemy(this.id(BuiltInRegistries.f_257033_.m_7981_((Object)mini.m_5456_()).m_135815_()), new ItemStack(mini), ManaInfusionProvider.ingr(full), 2500, "botania:flower_shrinking");
    }

    protected FinishedRecipe deconstruct(String id, ItemLike items, ItemLike block) {
        return FinishedRecipe.alchemy(this.id(id), new ItemStack(items, 4), ManaInfusionProvider.ingr(block), 25, "botania:block_deconstruction");
    }

    protected ResourceLocation id(String s) {
        return ResourceLocationHelper.prefix("mana_infusion/" + s);
    }

    protected static Ingredient ingr(ItemLike i) {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{i});
    }

    protected static class FinishedRecipe
    implements net.minecraft.data.recipes.FinishedRecipe {
        private static final StateIngredient CONJURATION = StateIngredientHelper.of((Block)BotaniaBlocks.conjurationCatalyst);
        private static final StateIngredient ALCHEMY = StateIngredientHelper.of((Block)BotaniaBlocks.alchemyCatalyst);
        private static final StateIngredient DIMENSION = StateIngredientHelper.of((Block)ExtraBotanyBlocks.dimensionCatalyst);
        private final ResourceLocation id;
        private final Ingredient input;
        private final ItemStack output;
        private final int mana;
        private final String group;
        @Nullable
        private final StateIngredient catalyst;

        public static FinishedRecipe conjuration(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            return new FinishedRecipe(id, output, input, mana, "", CONJURATION);
        }

        public static FinishedRecipe dimension(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            return new FinishedRecipe(id, output, input, mana, "", DIMENSION);
        }

        public static FinishedRecipe alchemy(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            return FinishedRecipe.alchemy(id, output, input, mana, "");
        }

        public static FinishedRecipe alchemy(ResourceLocation id, ItemStack output, Ingredient input, int mana, String group) {
            return new FinishedRecipe(id, output, input, mana, group, ALCHEMY);
        }

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            this(id, output, input, mana, "");
        }

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana, String group) {
            this(id, output, input, mana, group, null);
        }

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana, String group, @Nullable StateIngredient catalyst) {
            this.id = id;
            this.input = input;
            this.output = output;
            this.mana = mana;
            this.group = group;
            this.catalyst = catalyst;
        }

        public void m_7917_(JsonObject json) {
            json.add("input", this.input.m_43942_());
            json.add("output", (JsonElement)ItemNBTHelper.serializeStack((ItemStack)this.output));
            json.addProperty("mana", (Number)this.mana);
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            if (this.catalyst != null) {
                json.add("catalyst", (JsonElement)this.catalyst.serialize());
            }
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return BotaniaRecipeTypes.MANA_INFUSION_SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

