/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.forge.client;

import com.google.common.base.Suppliers;
import io.github.lounode.extrabotany.client.ExtraBotanyItemProperties;
import io.github.lounode.extrabotany.client.core.ExtraBotanyModels;
import io.github.lounode.extrabotany.client.gui.HUD;
import io.github.lounode.extrabotany.client.model.ExtrabotanyLayerDefinitions;
import io.github.lounode.extrabotany.client.renderer.BlockRenderLayers;
import io.github.lounode.extrabotany.client.renderer.ColorHandler;
import io.github.lounode.extrabotany.client.renderer.entity.EntityRenderers;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import vazkii.botania.api.BotaniaForgeClientCapabilities;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.forge.CapabilityUtil;
import vazkii.botania.network.TriConsumer;
import vazkii.patchouli.api.PatchouliAPI;

@Mod.EventBusSubscriber(modid="extrabotany", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ForgeClientInitializer {
    public static HUD hud;
    private static final Supplier<Map<BlockEntityType<?>, Function<BlockEntity, WandHUD>>> WAND_HUD;

    @SubscribeEvent
    public static void clientInit(FMLClientSetupEvent evt) {
        BlockRenderLayers.skipPlatformBlocks = true;
        BlockRenderLayers.init(ItemBlockRenderTypes::setRenderLayer);
        IEventBus bus = MinecraftForge.EVENT_BUS;
        hud = new HUD(Minecraft.m_91087_());
        PatchouliAPI.get().setConfigFlag("otaku_mode", ExtraBotanyConfig.client().otakuMode());
        bus.addGenericListener(BlockEntity.class, ForgeClientInitializer::attachBeCapabilities);
        bus.addListener(event -> HUD.onDisconnected());
    }

    private static void attachBeCapabilities(AttachCapabilitiesEvent<BlockEntity> e) {
        BlockEntity be = (BlockEntity)e.getObject();
        Function<BlockEntity, WandHUD> makeWandHud = WAND_HUD.get().get(be.m_58903_());
        if (makeWandHud != null) {
            e.addCapability(ResourceLocationHelper.prefix((String)"wand_hud"), CapabilityUtil.makeProvider((Capability)BotaniaForgeClientCapabilities.WAND_HUD, (Object)makeWandHud.apply(be)));
        }
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiOverlaysEvent e) {
        e.registerAbove(VanillaGuiOverlay.EXPERIENCE_BAR.id(), "hud", (gui, poseStack, partialTick, width, height) -> hud.onDrawScreenPost(poseStack, partialTick));
    }

    @SubscribeEvent
    public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions evt) {
        ExtrabotanyLayerDefinitions.init((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)evt).registerLayerDefinition(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers evt) {
        EntityRenderers.registerBlockEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)evt).registerBlockEntityRenderer(arg_0, arg_1));
        EntityRenderers.registerEntityRenderers((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterRenderers)evt).registerEntityRenderer(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block evt) {
        ColorHandler.submitBlocks((arg_0, arg_1) -> ((RegisterColorHandlersEvent.Block)evt).register(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item evt) {
        ColorHandler.submitItems((arg_0, arg_1) -> ((RegisterColorHandlersEvent.Item)evt).register(arg_0, arg_1));
    }

    @SubscribeEvent
    public static void onModelRegister(ModelEvent.RegisterAdditional evt) {
        ResourceManager resourceManager = Minecraft.m_91087_().m_91098_();
        ExtraBotanyModels.INSTANCE.onModelRegister(resourceManager, arg_0 -> ((ModelEvent.RegisterAdditional)evt).register(arg_0));
        ExtraBotanyItemProperties.init((TriConsumer<ItemLike, ResourceLocation, ClampedItemPropertyFunction>)((TriConsumer)(item, id, prop) -> ItemProperties.register((Item)item.m_5456_(), (ResourceLocation)id, (ItemPropertyFunction)prop)));
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.ModifyBakingResult evt) {
        ExtraBotanyModels.INSTANCE.onModelBake(evt.getModelBakery(), evt.getModels());
    }

    static {
        WAND_HUD = Suppliers.memoize(() -> {
            IdentityHashMap ret = new IdentityHashMap();
            ExtrabotanyFlowerBlocks.registerWandHudCaps((BotaniaBlockEntities.BECapConsumer<WandHUD>)((BotaniaBlockEntities.BECapConsumer)(factory, types) -> {
                for (BlockEntityType type : types) {
                    ret.put(type, factory);
                }
            }));
            return Collections.unmodifiableMap(ret);
        });
    }
}

