/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.network.clientbound;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lounode.extrabotany.common.bossevents.ComponentCodec;
import io.github.lounode.extrabotany.network.ExtrabotanyPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import vazkii.botania.common.lib.ResourceLocationHelper;

public record ColorfulBossEventPacket(UUID id, Operation operation) implements ExtrabotanyPacket
{
    public static final Codec<BossEvent.BossBarColor> BOSSBAR_COLOR_CODEC = Codec.STRING.xmap(BossEvent.BossBarColor::valueOf, Enum::name);
    public static final Codec<BossEvent.BossBarOverlay> BOSSBAR_OVERLAY_CODEC = Codec.STRING.xmap(BossEvent.BossBarOverlay::valueOf, Enum::name);
    public static final ResourceLocation ID = ResourceLocationHelper.prefix((String)"cbp");

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.id);
        buf.m_272073_(this.operation().getCodec(), (Object)this.operation());
    }

    public static ColorfulBossEventPacket decode(FriendlyByteBuf buf) {
        return new ColorfulBossEventPacket(buf.m_130259_(), (Operation)buf.m_271872_(Operation.CODEC));
    }

    public static ColorfulBossEventPacket createAddPacket(BossEvent event) {
        return new ColorfulBossEventPacket(event.m_18860_(), AddOperation.form(event));
    }

    public static ColorfulBossEventPacket createRemovePacket(UUID id) {
        return new ColorfulBossEventPacket(id, new RemoveOperation(id));
    }

    public static ColorfulBossEventPacket createUpdateProgressPacket(BossEvent event) {
        return new ColorfulBossEventPacket(event.m_18860_(), new UpdateProgressOperation(event.m_142717_()));
    }

    public static ColorfulBossEventPacket createUpdateNamePacket(BossEvent event) {
        return new ColorfulBossEventPacket(event.m_18860_(), new UpdateNameOperation(event.m_18861_()));
    }

    public static ColorfulBossEventPacket createUpdateStylePacket(BossEvent event) {
        return new ColorfulBossEventPacket(event.m_18860_(), new UpdateStyleOperation(event.m_18862_(), event.m_18863_()));
    }

    public static ColorfulBossEventPacket createUpdatePropertiesPacket(BossEvent event) {
        return new ColorfulBossEventPacket(event.m_18860_(), new UpdatePropertiesOperation(event.m_18864_(), event.m_18865_(), event.m_18866_()));
    }

    public void dispatch(Handler handler) {
        this.operation.dispatch(this.id, handler);
    }

    public static interface Operation {
        public static final Map<String, Supplier<Codec<? extends Operation>>> REGISTRY = new HashMap<String, Supplier<Codec<? extends Operation>>>();
        public static final Codec<Operation> CODEC = Codec.STRING.dispatch(Operation::getType, type -> REGISTRY.getOrDefault(type, () -> {
            throw new IllegalArgumentException("Unknown operation type: " + type);
        }).get());

        public Codec<? extends Operation> getCodec();

        public void dispatch(UUID var1, Handler var2);

        public String getType();

        public static void register(String type, Supplier<Codec<? extends Operation>> codecSupplier) {
            REGISTRY.put(type, codecSupplier);
        }
    }

    public record AddOperation(Component name, float progress, BossEvent.BossBarColor color, BossEvent.BossBarOverlay overlay, boolean darkenScreen, boolean playMusic, boolean createWorldFog) implements Operation
    {
        public static final Codec<AddOperation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(AddOperation::getType), (App)ComponentCodec.CODEC.fieldOf("name").forGetter(AddOperation::name), (App)Codec.FLOAT.fieldOf("progress").forGetter(AddOperation::progress), (App)BOSSBAR_COLOR_CODEC.fieldOf("color").forGetter(AddOperation::color), (App)BOSSBAR_OVERLAY_CODEC.fieldOf("overlay").forGetter(AddOperation::overlay), (App)Codec.BOOL.fieldOf("darkenScreen").forGetter(AddOperation::darkenScreen), (App)Codec.BOOL.fieldOf("playMusic").forGetter(AddOperation::playMusic), (App)Codec.BOOL.fieldOf("createWorldFog").forGetter(AddOperation::createWorldFog)).apply((Applicative)instance, (type, name, progress, color, overlay, darkenScreen, playMusic, createWorldFog) -> new AddOperation((Component)name, progress.floatValue(), (BossEvent.BossBarColor)color, (BossEvent.BossBarOverlay)overlay, (boolean)darkenScreen, (boolean)playMusic, (boolean)createWorldFog)));

        public static AddOperation form(BossEvent event) {
            return new AddOperation(event.m_18861_(), event.m_142717_(), event.m_18862_(), event.m_18863_(), event.m_18864_(), event.m_18865_(), event.m_18866_());
        }

        @Override
        public String getType() {
            return "add";
        }

        @Override
        public Codec<? extends Operation> getCodec() {
            return CODEC;
        }

        @Override
        public void dispatch(UUID uuid, Handler handler) {
            handler.add(uuid, this.name, this.progress, this.color, this.overlay, this.darkenScreen, this.playMusic, this.createWorldFog);
        }
    }

    public record RemoveOperation(UUID uuid) implements Operation
    {
        public static final Codec<RemoveOperation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(RemoveOperation::getType), (App)Codec.STRING.xmap(UUID::fromString, UUID::toString).fieldOf("uuid").forGetter(RemoveOperation::uuid)).apply((Applicative)instance, (type, uuid) -> new RemoveOperation((UUID)uuid)));

        @Override
        public String getType() {
            return "remove";
        }

        @Override
        public Codec<? extends Operation> getCodec() {
            return CODEC;
        }

        @Override
        public void dispatch(UUID uuid, Handler handler) {
            handler.remove(uuid);
        }
    }

    public record UpdateProgressOperation(float progress) implements Operation
    {
        public static final Codec<UpdateProgressOperation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(UpdateProgressOperation::getType), (App)Codec.FLOAT.fieldOf("progress").forGetter(UpdateProgressOperation::progress)).apply((Applicative)instance, (type, progress) -> new UpdateProgressOperation(progress.floatValue())));

        @Override
        public String getType() {
            return "update_progress";
        }

        @Override
        public Codec<? extends Operation> getCodec() {
            return CODEC;
        }

        @Override
        public void dispatch(UUID uuid, Handler handler) {
            handler.updateProgress(uuid, this.progress());
        }
    }

    public record UpdateNameOperation(Component name) implements Operation
    {
        public static final Codec<UpdateNameOperation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(UpdateNameOperation::getType), (App)ComponentCodec.CODEC.fieldOf("name").forGetter(UpdateNameOperation::name)).apply((Applicative)instance, (type, name) -> new UpdateNameOperation((Component)name)));

        @Override
        public Codec<? extends Operation> getCodec() {
            return CODEC;
        }

        @Override
        public void dispatch(UUID uuid, Handler handler) {
            handler.updateName(uuid, this.name());
        }

        @Override
        public String getType() {
            return "update_name";
        }
    }

    public record UpdateStyleOperation(BossEvent.BossBarColor color, BossEvent.BossBarOverlay overlay) implements Operation
    {
        public static final Codec<UpdateStyleOperation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(UpdateStyleOperation::getType), (App)BOSSBAR_COLOR_CODEC.fieldOf("color").forGetter(UpdateStyleOperation::color), (App)BOSSBAR_OVERLAY_CODEC.fieldOf("overlay").forGetter(UpdateStyleOperation::overlay)).apply((Applicative)instance, (type, color, overlay) -> new UpdateStyleOperation((BossEvent.BossBarColor)color, (BossEvent.BossBarOverlay)overlay)));

        @Override
        public Codec<? extends Operation> getCodec() {
            return CODEC;
        }

        @Override
        public void dispatch(UUID uuid, Handler handler) {
            handler.updateStyle(uuid, this.color(), this.overlay());
        }

        @Override
        public String getType() {
            return "update_style";
        }
    }

    public record UpdatePropertiesOperation(boolean darkenScreen, boolean playMusic, boolean createWorldFog) implements Operation
    {
        public static final Codec<UpdatePropertiesOperation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(UpdatePropertiesOperation::getType), (App)Codec.BOOL.fieldOf("darkenScreen").forGetter(UpdatePropertiesOperation::darkenScreen), (App)Codec.BOOL.fieldOf("playMusic").forGetter(UpdatePropertiesOperation::playMusic), (App)Codec.BOOL.fieldOf("createWorldFog").forGetter(UpdatePropertiesOperation::createWorldFog)).apply((Applicative)instance, (type, darkenScreen, playMusic, createWorldFog) -> new UpdatePropertiesOperation((boolean)darkenScreen, (boolean)playMusic, (boolean)createWorldFog)));

        @Override
        public Codec<? extends Operation> getCodec() {
            return CODEC;
        }

        @Override
        public void dispatch(UUID uuid, Handler handler) {
            handler.updateProperties(uuid, this.darkenScreen(), this.playMusic(), this.createWorldFog());
        }

        @Override
        public String getType() {
            return "update_properties";
        }
    }

    public static interface Handler {
        default public void add(UUID uuid, Component name, float progress, BossEvent.BossBarColor color, BossEvent.BossBarOverlay overlay, boolean darkenScreen, boolean playMusic, boolean createWorldFog) {
        }

        default public void remove(UUID uuid) {
        }

        default public void updateProgress(UUID uuid, float progress) {
        }

        default public void updateName(UUID uuid, Component name) {
        }

        default public void updateStyle(UUID uuid, BossEvent.BossBarColor color, BossEvent.BossBarOverlay overlay) {
        }

        default public void updateProperties(UUID uuid, boolean darkenScreen, boolean playMusic, boolean createWorldFog) {
        }
    }
}

