/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.library.util;

import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class FakePlayerUtil {
    private static final UUID ID = UUID.randomUUID();

    public static boolean isFakePlayer(Entity attacker) {
        return attacker instanceof FakePlayer;
    }

    public static WeakReference<FakePlayer> initFakePlayer(ServerLevel ws, String blockName) {
        String name = "fake_player." + blockName;
        GameProfile breakerProfile = new GameProfile(ID, name);
        WeakReference<FakePlayer> fakePlayer = new WeakReference<FakePlayer>(FakePlayerFactory.get((ServerLevel)ws, (GameProfile)breakerProfile));
        if (fakePlayer == null || fakePlayer.get() == null) {
            fakePlayer = null;
            return null;
        }
        ((FakePlayer)fakePlayer.get()).m_6853_(true);
        ((FakePlayer)fakePlayer.get()).f_8906_ = new ServerGamePacketListenerImpl(ws.m_7654_(), new Connection(PacketFlow.SERVERBOUND), (ServerPlayer)fakePlayer.get()){

            public void m_9829_(Packet<?> packetIn) {
            }
        };
        ((FakePlayer)fakePlayer.get()).m_20225_(true);
        return fakePlayer;
    }

    public static void tryEquipItem(LazyOptional<IItemHandler> i, WeakReference<FakePlayer> fp, int slot, InteractionHand hand) {
        if (fp == null) {
            return;
        }
        i.ifPresent(inv -> {
            ItemStack maybeTool = inv.getStackInSlot(0);
            if (!maybeTool.m_41619_() && maybeTool.m_41613_() <= 0) {
                maybeTool = ItemStack.f_41583_;
            }
            if (!maybeTool.equals(((FakePlayer)fp.get()).m_21120_(hand))) {
                ((FakePlayer)fp.get()).m_21008_(hand, maybeTool);
            }
        });
    }

    public static InteractionResult interactUseOnBlock(WeakReference<FakePlayer> fakePlayer, Level world, BlockPos targetPos, InteractionHand hand, Direction facing) throws Exception {
        if (fakePlayer == null) {
            return InteractionResult.FAIL;
        }
        Direction placementOn = facing == null ? ((FakePlayer)fakePlayer.get()).m_6374_() : facing;
        BlockHitResult blockraytraceresult = new BlockHitResult(((FakePlayer)fakePlayer.get()).m_20154_(), placementOn, targetPos, true);
        ItemStack itemInHand = ((FakePlayer)fakePlayer.get()).m_21120_(hand);
        InteractionResult result = ((FakePlayer)fakePlayer.get()).f_8941_.m_7179_((ServerPlayer)fakePlayer.get(), world, itemInHand, hand, blockraytraceresult);
        return result;
    }

    public static void syncEquippedItem(ItemStackHandler inv, WeakReference<FakePlayer> fp, int slot, InteractionHand hand) {
        if (fp == null) {
            return;
        }
        inv.setStackInSlot(slot, ItemStack.f_41583_);
        inv.insertItem(slot, ((FakePlayer)fp.get()).m_21120_(hand), false);
    }

    public static void tryEquipItem(ItemStack item, WeakReference<FakePlayer> fp, InteractionHand hand) {
        if (fp == null) {
            return;
        }
        ((FakePlayer)fp.get()).m_21008_(hand, item);
    }
}

