/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.apiculture.genetics;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.genetics.IEffect;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.IRegistryAlleleValue;
import forestry.core.render.ParticleRender;
import java.util.List;
import net.minecraft.core.BlockPos;

public interface IBeeEffect
extends IEffect,
IRegistryAlleleValue {
    @Override
    default public IEffectData validateStorage(IEffectData storedData) {
        return storedData;
    }

    @Override
    default public boolean isCombinable() {
        return false;
    }

    default public IEffectData doEffect(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        return storedData;
    }

    default public IEffectData doFX(IGenome genome, IEffectData storedData, IBeeHousing housing) {
        IBeekeepingLogic beekeepingLogic = housing.getBeekeepingLogic();
        List<BlockPos> flowerPositions = beekeepingLogic.getFlowerPositions();
        ParticleRender.addBeeHiveFX(housing, genome, flowerPositions);
        return storedData;
    }
}

