/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.genetics;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import forestry.api.ForestryCapabilities;
import forestry.api.genetics.IAlyzerPlugin;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IBreedingTrackerHandler;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.IMutationManager;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.alleles.IKaryotype;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.api.plugin.IForestryPlugin;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public interface ISpeciesType<S extends ISpecies<I>, I extends IIndividual>
extends IBreedingTrackerHandler {
    public ResourceLocation id();

    public IKaryotype getKaryotype();

    @Nullable
    public ILifeStage getLifeStage(ItemStack var1);

    public IMutationManager<S> getMutations();

    public List<S> getAllSpecies();

    public S getSpecies(ResourceLocation var1);

    @Nullable
    public S getSpeciesSafe(ResourceLocation var1);

    public S getRandomSpecies(RandomSource var1);

    public ImmutableSet<ResourceLocation> getAllSpeciesIds();

    public int getSpeciesCount();

    public S getDefaultSpecies();

    public ILifeStage getDefaultStage();

    public String getTranslationKey();

    default public MutableComponent getDisplayName() {
        return Component.m_237115_((String)this.getTranslationKey());
    }

    default public ItemStack createDefaultStack() {
        return this.getDefaultSpecies().createStack(this.getDefaultStage());
    }

    public Collection<ILifeStage> getLifeStages();

    public IBreedingTracker getBreedingTracker(LevelAccessor var1, @Nullable GameProfile var2);

    default public ILifeStage getTypeForMutation(int position) {
        return this.getDefaultStage();
    }

    public IAlyzerPlugin getAlyzerPlugin();

    public ItemStack createStack(I var1, ILifeStage var2);

    public ItemStack createStack(ResourceLocation var1, ILifeStage var2);

    public Codec<? extends I> getIndividualCodec();

    public boolean isMember(IIndividual var1);

    default public boolean isMember(ItemStack stack) {
        IIndividualHandlerItem individual = (IIndividualHandlerItem)stack.getCapability(ForestryCapabilities.INDIVIDUAL_HANDLER_ITEM).orElse(null);
        return individual != null && this.isMember(individual.getIndividual());
    }

    public float getResearchSuitability(S var1, ItemStack var2);

    public List<ItemStack> getResearchBounty(S var1, Level var2, GameProfile var3, I var4, int var5);

    public String getBreedingTrackerFile(@Nullable GameProfile var1);

    public IBreedingTracker createBreedingTracker();

    public IBreedingTracker createBreedingTracker(CompoundTag var1);

    public I createRandomIndividual(RandomSource var1);

    public void initializeBreedingTracker(IBreedingTracker var1, @Nullable Level var2, @Nullable GameProfile var3);

    public Pair<ImmutableMap<ResourceLocation, S>, IMutationManager<S>> handleSpeciesRegistration(List<IForestryPlugin> var1);

    public void onSpeciesRegistered(ImmutableMap<ResourceLocation, S> var1, IMutationManager<S> var2);

    default public <T extends ISpeciesType<?, ?>> T cast() {
        return (T)this;
    }
}

