/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.ForestryTags;
import forestry.api.apiculture.IFlowerType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class FlowerType
implements IFlowerType {
    private final TagKey<Block> acceptableFlowers;
    private final boolean dominant;

    public FlowerType(TagKey<Block> acceptableFlowers, boolean dominant) {
        this.acceptableFlowers = acceptableFlowers;
        this.dominant = dominant;
    }

    @Override
    public boolean isAcceptableFlower(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_204336_(this.acceptableFlowers);
    }

    @Override
    public boolean plantRandomFlower(Level level, BlockPos pos, List<BlockState> nearbyFlowers) {
        if (level.m_46805_(pos) && level.m_46859_(pos)) {
            for (BlockState state : nearbyFlowers) {
                if (!state.m_204336_(ForestryTags.Blocks.PLANTABLE_FLOWERS) || !state.m_60710_((LevelReader)level, pos)) continue;
                if (state.m_61138_((Property)DoublePlantBlock.f_52858_)) {
                    BlockPos topPos = pos.m_7494_();
                    if (!level.m_46859_(topPos)) continue;
                    return level.m_46597_(pos, (BlockState)state.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER)) && level.m_46597_(topPos, (BlockState)state.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER));
                }
                return level.m_46597_(pos, state);
            }
        }
        return false;
    }

    @Override
    public boolean isDominant() {
        return this.dominant;
    }
}

