/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.IForestryApi;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.genetics.ForestrySpeciesTypes;
import forestry.api.genetics.IMutationManager;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.core.genetics.BreedingTracker;
import forestry.core.utils.SpeciesUtil;
import net.minecraft.nbt.CompoundTag;

public class ApiaristTracker
extends BreedingTracker
implements IApiaristTracker {
    private int queensTotal = 0;
    private int dronesTotal = 0;
    private int princessesTotal = 0;

    public ApiaristTracker() {
        super(ForestrySpeciesTypes.BEE);
    }

    @Override
    public void writeToNbt(CompoundTag nbt) {
        super.writeToNbt(nbt);
        this.writeUpdateData(nbt);
    }

    @Override
    protected void writeUpdateData(CompoundTag nbt) {
        nbt.m_128405_("QueensTotal", this.queensTotal);
        nbt.m_128405_("PrincessesTotal", this.princessesTotal);
        nbt.m_128405_("DronesTotal", this.dronesTotal);
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        super.readFromNbt(nbt);
        this.queensTotal = nbt.m_128451_("QueensTotal");
        this.princessesTotal = nbt.m_128451_("PrincessesTotal");
        this.dronesTotal = nbt.m_128451_("DronesTotal");
    }

    @Override
    public void registerPickup(ISpecies<?> species) {
        IMutationManager<ISpecies<?>> manager = IForestryApi.INSTANCE.getGeneticManager().getMutations((ISpeciesType)SpeciesUtil.BEE_TYPE.get());
        if (manager.getMutationsFrom(species).isEmpty()) {
            this.registerSpecies(species);
        }
    }

    @Override
    public void registerQueen(IBee bee) {
        ++this.queensTotal;
        this.registerBirth(bee.getSpecies());
    }

    @Override
    public int getQueenCount() {
        return this.queensTotal;
    }

    @Override
    public void registerPrincess(IBee bee) {
        ++this.princessesTotal;
        this.registerBirth(bee.getSpecies());
    }

    @Override
    public int getPrincessCount() {
        return this.princessesTotal;
    }

    @Override
    public void registerDrone(IBee bee) {
        ++this.dronesTotal;
        this.registerBirth(bee.getSpecies());
    }

    @Override
    public int getDroneCount() {
        return this.dronesTotal;
    }
}

