/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.effects;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IIndividualLiving;
import forestry.api.genetics.alleles.ForestryAlleles;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.apiculture.genetics.effects.NonStackingBeeEffect;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public class AgingBeeEffect
extends NonStackingBeeEffect {
    protected boolean aging;

    public AgingBeeEffect(boolean dominant, boolean aging) {
        super(dominant);
        this.aging = aging;
    }

    @Override
    protected void doEffectForHive(Level level, IBeeHousing housing) {
        IIndividual individual;
        IIndividualHandlerItem handler;
        if (!housing.getErrorLogic().hasErrors() && (handler = IIndividualHandlerItem.get(housing.getBeeInventory().getQueen())) != null && handler.getStage() == BeeLifeStage.QUEEN && (individual = handler.getIndividual()) instanceof IIndividualLiving) {
            IIndividualLiving queen = (IIndividualLiving)individual;
            RandomSource rand = level.m_213780_();
            int life = queen.getMaxHealth() / ForestryAlleles.LIFESPAN_NORMAL.value();
            if (rand.m_188503_(ForestryAlleles.LIFESPAN_NORMAL.value()) < queen.getMaxHealth() % ForestryAlleles.LIFESPAN_NORMAL.value()) {
                ++life;
            }
            if (this.aging) {
                queen.setHealth(Math.max(1, queen.getHealth() - life));
            } else {
                queen.setHealth((int)Math.min((long)queen.getMaxHealth(), Math.min(Integer.MAX_VALUE, (long)queen.getHealth() + (long)life)));
            }
            queen.saveToStack(housing.getBeeInventory().getQueen());
        }
    }
}

