/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import com.mojang.authlib.GameProfile;
import forestry.api.IForestryApi;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.climate.IClimateControlled;
import forestry.api.climate.IClimateProvider;
import forestry.api.core.HumidityType;
import forestry.api.core.TemperatureType;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.apiculture.AlvearyBeeModifier;
import forestry.apiculture.InventoryBeeHousing;
import forestry.apiculture.multiblock.AlvearyMultiblockSizeLimits;
import forestry.apiculture.multiblock.IAlvearyControllerInternal;
import forestry.apiculture.multiblock.TileAlvearyPlain;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.multiblock.RectangularMultiblockControllerBase;
import forestry.core.render.ParticleRender;
import forestry.core.utils.NetworkUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AlvearyController
extends RectangularMultiblockControllerBase
implements IAlvearyControllerInternal,
IClimateControlled {
    private final InventoryBeeHousing inventory;
    private final IBeekeepingLogic beekeepingLogic;
    private IClimateProvider climate = IForestryApi.INSTANCE.getClimateManager().createDummyClimateProvider();
    private byte temperatureSteps;
    private byte humiditySteps;
    private final Set<IBeeModifier> beeModifiers = new HashSet<IBeeModifier>();
    private final Set<IBeeListener> beeListeners = new HashSet<IBeeListener>();
    private final Set<IAlvearyComponent.Climatiser> climatisers = new HashSet<IAlvearyComponent.Climatiser>();
    private final Set<IAlvearyComponent.Active> activeComponents = new HashSet<IAlvearyComponent.Active>();
    private int breedingProgressPercent = 0;

    public AlvearyController(Level world) {
        super(world, AlvearyMultiblockSizeLimits.instance);
        this.inventory = new InventoryBeeHousing(9);
        this.beekeepingLogic = IForestryApi.INSTANCE.getHiveManager().createBeekeepingLogic(this);
        this.beeModifiers.add(new AlvearyBeeModifier());
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beekeepingLogic;
    }

    @Override
    public IInventoryAdapter getInternalInventory() {
        if (this.isAssembled()) {
            return this.inventory;
        }
        return FakeInventoryAdapter.INSTANCE;
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return this.beeListeners;
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return this.beeModifiers;
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockComponent part, CompoundTag data) {
        this.read(data);
    }

    @Override
    protected void onBlockAdded(IMultiblockComponent newPart) {
        if (newPart instanceof IAlvearyComponent) {
            if (newPart instanceof IAlvearyComponent.BeeModifier) {
                IAlvearyComponent.BeeModifier alvearyBeeModifier = (IAlvearyComponent.BeeModifier)newPart;
                IBeeModifier beeModifier = alvearyBeeModifier.getBeeModifier();
                this.beeModifiers.add(beeModifier);
            }
            if (newPart instanceof IAlvearyComponent.BeeListener) {
                IAlvearyComponent.BeeListener beeListenerSource = (IAlvearyComponent.BeeListener)newPart;
                IBeeListener beeListener = beeListenerSource.getBeeListener();
                this.beeListeners.add(beeListener);
            }
            if (newPart instanceof IAlvearyComponent.Climatiser) {
                this.climatisers.add((IAlvearyComponent.Climatiser)newPart);
            }
            if (newPart instanceof IAlvearyComponent.Active) {
                this.activeComponents.add((IAlvearyComponent.Active)newPart);
            }
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockComponent oldPart) {
        if (oldPart instanceof IAlvearyComponent) {
            if (oldPart instanceof IAlvearyComponent.BeeModifier) {
                IAlvearyComponent.BeeModifier alvearyBeeModifier = (IAlvearyComponent.BeeModifier)oldPart;
                IBeeModifier beeModifier = alvearyBeeModifier.getBeeModifier();
                this.beeModifiers.remove(beeModifier);
            }
            if (oldPart instanceof IAlvearyComponent.BeeListener) {
                IAlvearyComponent.BeeListener beeListenerSource = (IAlvearyComponent.BeeListener)oldPart;
                IBeeListener beeListener = beeListenerSource.getBeeListener();
                this.beeListeners.remove(beeListener);
            }
            if (oldPart instanceof IAlvearyComponent.Climatiser) {
                this.climatisers.remove(oldPart);
            }
            if (oldPart instanceof IAlvearyComponent.Active) {
                this.activeComponents.remove(oldPart);
            }
        }
    }

    @Override
    public void onDestroyed(BlockPos lastPos) {
        Containers.m_19002_((Level)this.level, (BlockPos)lastPos, (Container)this.inventory);
    }

    @Override
    protected void onMachineAssembled() {
        super.onMachineAssembled();
        this.climate = IForestryApi.INSTANCE.getClimateManager().createClimateProvider((LevelReader)this.level, this.getCenterCoord());
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        super.isMachineWhole();
        BlockPos maximumCoord = this.getMaximumCoord();
        BlockPos minimumCoord = this.getMinimumCoord();
        int slabY = maximumCoord.m_123342_() + 1;
        for (int slabX = minimumCoord.m_123341_(); slabX <= maximumCoord.m_123341_(); ++slabX) {
            for (int slabZ = minimumCoord.m_123343_(); slabZ <= maximumCoord.m_123343_(); ++slabZ) {
                BlockPos pos = new BlockPos(slabX, slabY, slabZ);
                BlockState state = this.level.m_8055_(pos);
                if (state.m_204336_(BlockTags.f_13097_)) continue;
                throw new MultiblockValidationException(Component.m_237115_((String)"for.multiblock.alveary.error.needSlabs").getString());
            }
        }
        int airY = maximumCoord.m_123342_();
        for (int airX = minimumCoord.m_123341_() - 1; airX <= maximumCoord.m_123341_() + 1; ++airX) {
            for (int airZ = minimumCoord.m_123343_() - 1; airZ <= maximumCoord.m_123343_() + 1; ++airZ) {
                BlockPos pos;
                BlockState blockState;
                if (this.isCoordInMultiblock(airX, airY, airZ) || !(blockState = this.level.m_8055_(pos = new BlockPos(airX, airY, airZ))).m_60804_((BlockGetter)this.level, pos)) continue;
                throw new MultiblockValidationException(Component.m_237115_((String)"for.multiblock.alveary.error.needSpace").getString());
            }
        }
    }

    @Override
    protected void isGoodForExteriorLevel(IMultiblockComponent part, int level) throws MultiblockValidationException {
        if (level == 2 && !(part instanceof TileAlvearyPlain)) {
            throw new MultiblockValidationException(Component.m_237115_((String)"for.multiblock.alveary.error.needPlainOnTop").getString());
        }
    }

    @Override
    protected void isGoodForInterior(IMultiblockComponent part) throws MultiblockValidationException {
        if (!(part instanceof TileAlvearyPlain)) {
            throw new MultiblockValidationException(Component.m_237115_((String)"for.multiblock.alveary.error.needPlainInterior").getString());
        }
    }

    @Override
    protected void onAssimilate(IMultiblockControllerInternal assimilated) {
    }

    @Override
    public void onAssimilated(IMultiblockControllerInternal assimilator) {
    }

    @Override
    protected boolean serverTick(int tickCount) {
        for (IAlvearyComponent.Active activeComponent : this.activeComponents) {
            activeComponent.updateServer(tickCount);
        }
        boolean canWork = this.beekeepingLogic.canWork();
        if (canWork) {
            this.beekeepingLogic.doWork();
        }
        this.temperatureSteps = 0;
        this.humiditySteps = 0;
        for (IAlvearyComponent.Climatiser climatiser : this.climatisers) {
            climatiser.changeClimate(tickCount, this);
        }
        if ((this.level.m_46467_() & 0x3FL) == 0L) {
            this.climate = IForestryApi.INSTANCE.getClimateManager().createClimateProvider((LevelReader)this.level, this.getCenterCoord());
        }
        return canWork;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void clientTick(int tickCount) {
        for (IAlvearyComponent.Active activeComponent : this.activeComponents) {
            activeComponent.updateClient(tickCount);
        }
        if (this.beekeepingLogic.canDoBeeFX() && this.updateOnInterval(2)) {
            this.beekeepingLogic.doBeeFX();
            if (this.updateOnInterval(50)) {
                BlockPos center = this.getCenterCoord();
                float fxX = (float)center.m_123341_() + 0.5f;
                float fxY = (float)center.m_123342_() + 1.0f;
                float fxZ = (float)center.m_123343_() + 0.5f;
                float distanceFromCenter = 1.6f;
                float leftRightSpreadFromCenter = distanceFromCenter * (this.level.f_46441_.m_188501_() - 0.5f);
                float upSpread = this.level.f_46441_.m_188501_() * 0.8f;
                ParticleRender.addEntityHoneyDustFX(this.level, fxX - distanceFromCenter, fxY += upSpread, fxZ + leftRightSpreadFromCenter);
                ParticleRender.addEntityHoneyDustFX(this.level, fxX + distanceFromCenter, fxY, fxZ + leftRightSpreadFromCenter);
                ParticleRender.addEntityHoneyDustFX(this.level, fxX + leftRightSpreadFromCenter, fxY, fxZ - distanceFromCenter);
                ParticleRender.addEntityHoneyDustFX(this.level, fxX + leftRightSpreadFromCenter, fxY, fxZ + distanceFromCenter);
            }
        }
    }

    @Override
    public CompoundTag write(CompoundTag data) {
        data = super.write(data);
        data.m_128344_("temperatureSteps", this.temperatureSteps);
        data.m_128344_("humiditySteps", this.humiditySteps);
        this.beekeepingLogic.write(data);
        this.inventory.write(data);
        return data;
    }

    @Override
    public void read(CompoundTag data) {
        super.read(data);
        this.temperatureSteps = data.m_128445_("temperatureSteps");
        this.humiditySteps = data.m_128445_("humiditySteps");
        this.beekeepingLogic.read(data);
        this.inventory.read(data);
    }

    @Override
    public void formatDescriptionPacket(CompoundTag data) {
        this.write(data);
        this.beekeepingLogic.write(data);
    }

    @Override
    public void decodeDescriptionPacket(CompoundTag data) {
        this.read(data);
        this.beekeepingLogic.read(data);
    }

    @Override
    public BlockPos getCoordinates() {
        BlockPos coord = this.getCenterCoord();
        return coord.m_7918_(0, 1, 0);
    }

    @Override
    public Vec3 getBeeFXCoordinates() {
        BlockPos coord = this.getCenterCoord();
        return new Vec3((double)coord.m_123341_() + 0.5, (double)coord.m_123342_() + 1.5, (double)coord.m_123343_() + 0.5);
    }

    @Override
    public HumidityType humidity() {
        return this.climate.humidity().up(this.humiditySteps);
    }

    @Override
    public TemperatureType temperature() {
        IBeeModifier beeModifier = IForestryApi.INSTANCE.getHiveManager().createBeeHousingModifier(this);
        if ((beeModifier.isHellish() || this.getBiome().m_203656_(BiomeTags.f_207612_)) && this.temperatureSteps >= 0) {
            return TemperatureType.HELLISH;
        }
        return this.climate.temperature().up(this.temperatureSteps);
    }

    @Override
    public GameProfile getOwner() {
        return this.getOwnerHandler().getOwner();
    }

    @Override
    public String getUnlocalizedType() {
        return "for.multiblock.alveary.type";
    }

    @Override
    public Holder<Biome> getBiome() {
        return this.level.m_204166_(this.getReferenceCoord());
    }

    @Override
    public int getBlockLightValue() {
        BlockPos topCenter = this.getTopCenterCoord();
        return this.level.m_46803_(topCenter.m_7494_());
    }

    @Override
    public boolean canBlockSeeTheSky() {
        BlockPos topCenter = this.getTopCenterCoord();
        return this.level.m_46861_(topCenter.m_7918_(0, 2, 0));
    }

    @Override
    public boolean isRaining() {
        BlockPos topCenter = this.getTopCenterCoord();
        return this.level.m_46758_(topCenter.m_7918_(0, 2, 0));
    }

    @Override
    public void addTemperatureChange(byte steps) {
        this.temperatureSteps = (byte)(this.temperatureSteps + steps);
    }

    @Override
    public void addHumidityChange(byte steps) {
        this.humiditySteps = (byte)(this.humiditySteps + steps);
    }

    @Override
    public int getHealthScaled(int i) {
        return this.breedingProgressPercent * i / 100;
    }

    @Override
    public void writeGuiData(FriendlyByteBuf data) {
        data.m_130130_(this.beekeepingLogic.getBeeProgressPercent());
        NetworkUtil.writeClimateState(data, this.climate.temperature(), this.climate.humidity());
        data.writeByte((int)this.temperatureSteps);
        data.writeByte((int)this.humiditySteps);
    }

    @Override
    public void readGuiData(FriendlyByteBuf data) {
        this.breedingProgressPercent = data.m_130242_();
        this.climate = NetworkUtil.readClimateState(data);
        this.temperatureSteps = data.readByte();
        this.humiditySteps = data.readByte();
    }
}

