/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import forestry.core.utils.ModUtil;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;

public class BeeParticleData
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<BeeParticleData> DESERIALIZER = new ParticleOptions.Deserializer<BeeParticleData>(){

        @Nonnull
        public BeeParticleData fromCommand(@Nonnull ParticleType<BeeParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            long direction = reader.readLong();
            reader.expect(' ');
            int color = reader.readInt();
            return new BeeParticleData(type, direction, color);
        }

        public BeeParticleData fromNetwork(@Nonnull ParticleType<BeeParticleData> type, FriendlyByteBuf buf) {
            return new BeeParticleData(type, buf.readLong(), buf.readInt());
        }
    };
    public final ParticleType<BeeParticleData> type;
    public final BlockPos destination;
    public final int color;

    public static Codec<BeeParticleData> createCodec(ParticleType<BeeParticleData> type) {
        return RecordCodecBuilder.create(val -> val.group((App)Codec.LONG.fieldOf("direction").forGetter(data -> data.destination.m_121878_()), (App)Codec.INT.fieldOf("color").forGetter(data -> data.color)).apply((Applicative)val, (destination1, color1) -> new BeeParticleData(type, (long)destination1, (int)color1)));
    }

    public BeeParticleData(ParticleType<BeeParticleData> type, long destination, int color) {
        this.type = type;
        this.destination = BlockPos.m_122022_((long)destination);
        this.color = color;
    }

    public BeeParticleData(ParticleType<BeeParticleData> type, BlockPos destination, int color) {
        this.type = type;
        this.destination = destination;
        this.color = color;
    }

    @Nonnull
    public ParticleType<?> m_6012_() {
        return this.type;
    }

    public void m_7711_(@Nonnull FriendlyByteBuf buffer) {
        buffer.writeRegistryId(ForgeRegistries.PARTICLE_TYPES, this.type);
        buffer.writeLong(this.destination.m_121878_());
        buffer.writeInt(this.color);
    }

    @Nonnull
    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %d %d %d", ModUtil.getRegistryName(this.m_6012_()), this.destination.m_123341_(), this.destination.m_123342_(), this.destination.m_123343_(), this.color);
    }
}

