/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.arboriculture.genetics.TreeLifeStage;
import forestry.api.genetics.ILifeStage;
import forestry.arboriculture.tiles.TileSapling;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.SpeciesUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockSapling
extends Block
implements BonemealableBlock,
EntityBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);

    public BlockSapling() {
        super(BlockBehaviour.Properties.m_284310_().m_60910_().m_60978_(0.0f).m_60918_(SoundType.f_56740_).m_60977_());
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if ((double)rand.m_188501_() > 0.1) {
            return;
        }
        TileTreeContainer tile = TileUtil.getTile((BlockGetter)world, pos, TileTreeContainer.class);
        if (tile == null) {
            return;
        }
        tile.onBlockTick((Level)world, pos, state, rand);
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockReader, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileSapling(pos, state);
    }

    public static boolean canBlockStay(BlockGetter level, BlockPos pos) {
        TileSapling tile = TileUtil.getTile(level, pos, TileSapling.class);
        if (tile == null) {
            return false;
        }
        ITree tree = tile.getTree();
        return tree != null && tree.canStay(level, pos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_ && !BlockSapling.canBlockStay((BlockGetter)level, pos)) {
            level.m_46961_(pos, true);
        }
    }

    public List<ItemStack> m_49635_(BlockState blockState, LootParams.Builder builder) {
        ItemStack drop = BlockSapling.getDrop((BlockEntity)builder.m_287261_(LootContextParams.f_81462_));
        if (!drop.m_41619_()) {
            return Collections.singletonList(drop);
        }
        return Collections.emptyList();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        TileSapling sapling = TileUtil.getTile(level, pos, TileSapling.class);
        if (sapling == null || sapling.getTree() == null) {
            return ItemStack.f_41583_;
        }
        return ((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).createStack(sapling.getTree(), (ILifeStage)TreeLifeStage.SAPLING);
    }

    private static ItemStack getDrop(BlockEntity blockEntity) {
        TileSapling sapling;
        ITree tree;
        if (blockEntity instanceof TileSapling && (tree = (sapling = (TileSapling)blockEntity).getTree()) != null) {
            return ((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).createStack(tree, (ILifeStage)TreeLifeStage.SAPLING);
        }
        return ItemStack.f_41583_;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level world, RandomSource rand, BlockPos pos, BlockState state) {
        if (world.f_46441_.m_188501_() >= 0.45f) {
            return false;
        }
        TileSapling saplingTile = TileUtil.getTile((BlockGetter)world, pos, TileSapling.class);
        return saplingTile == null || saplingTile.canAcceptBoneMeal(rand);
    }

    public void m_214148_(ServerLevel world, RandomSource rand, BlockPos pos, BlockState blockState) {
        TileSapling saplingTile = TileUtil.getTile((BlockGetter)world, pos, TileSapling.class);
        if (saplingTile != null) {
            saplingTile.tryGrow(rand, true);
        }
    }
}

