/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.commands;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.ISpeciesType;
import forestry.core.commands.ISpeciesArgumentType;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class LifeStageArgument
implements ISpeciesArgumentType<ILifeStage> {
    static final DynamicCommandExceptionType INVALID_VALUE = new DynamicCommandExceptionType(found -> Component.m_237110_((String)"argument.enum.invalid", (Object[])new Object[]{found}));
    private final ImmutableMap<String, ILifeStage> stages;
    private final ISpeciesType<?, ?> type;

    public LifeStageArgument(ISpeciesType<?, ?> type) {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)type.getLifeStages().size());
        for (ILifeStage stage : type.getLifeStages()) {
            builder.put((Object)stage.m_7912_(), (Object)stage);
        }
        this.stages = builder.build();
        this.type = type;
    }

    public ILifeStage parse(StringReader reader) throws CommandSyntaxException {
        String s = reader.readUnquotedString();
        ILifeStage stage = (ILifeStage)this.stages.get((Object)s);
        if (stage == null) {
            throw INVALID_VALUE.create((Object)s);
        }
        return stage;
    }

    @Override
    public ISpeciesType<?, ?> type() {
        return this.type;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_((Iterable)this.stages.keySet(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return this.stages.keySet().stream().limit(2L).toList();
    }
}

