/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.IForestryApi;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.IMutationManager;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.core.features.CoreItems;
import forestry.core.genetics.AlleleUtil;
import forestry.core.genetics.mutations.EnumMutateChance;
import forestry.core.items.ItemForestry;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class ItemResearchNote
extends ItemForestry {
    private static final String PARENT_0_KEY = "P0";
    private static final String PARENT_1_KEY = "P1";
    private static final String RESULT_KEY = "RS";
    private static final String TYPE_KEY = "ROT";
    private static final String RESEARCHER_KEY = "RES";
    private static final String NBT_INNER = "INN";

    public ItemResearchNote() {
        super(new Item.Properties());
    }

    public Component m_7626_(ItemStack itemstack) {
        ResearchNote note = new ResearchNote(itemstack.m_41783_());
        String researcherName = note.researcher == null ? "Sengir" : note.researcher.getName();
        return Component.m_237110_((String)this.m_5671_(itemstack), (Object[])new Object[]{researcherName});
    }

    @Override
    public void m_7373_(ItemStack itemstack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        ResearchNote note = new ResearchNote(itemstack.m_41783_());
        note.addTooltip(list);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack heldItem = playerIn.m_21120_(handIn);
        if (worldIn.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)heldItem);
        }
        ResearchNote note = new ResearchNote(heldItem.m_41783_());
        if (ItemResearchNote.registerResults(worldIn, playerIn, note.inner)) {
            heldItem.m_41774_(1);
        }
        return InteractionResultHolder.m_19090_((Object)heldItem);
    }

    @Nullable
    private static IMutation<?> getEncodedMutation(CompoundTag compound) {
        ISpeciesType<?, ?> type = IForestryApi.INSTANCE.getGeneticManager().getSpeciesTypeSafe(new ResourceLocation(compound.m_128461_(TYPE_KEY)));
        if (type == null) {
            return null;
        }
        Object parent0 = AlleleUtil.getSpecies(type, compound, PARENT_0_KEY);
        Object parent1 = AlleleUtil.getSpecies(type, compound, PARENT_1_KEY);
        if (parent0 == null || parent1 == null) {
            return null;
        }
        ISpecies result = null;
        if (compound.m_128441_(RESULT_KEY)) {
            result = (ISpecies)AlleleUtil.getSpecies(type, compound, RESULT_KEY);
        }
        IMutation<?> encoded = null;
        IMutationManager<?> mutations = type.getMutations();
        for (IMutation<?> mutation : mutations.getMutationsFrom(parent0)) {
            if (!mutation.isPartner((ISpecies<?>)parent1) || result != null && !mutation.getResult().id().equals((Object)result.id())) continue;
            encoded = mutation;
            break;
        }
        return encoded;
    }

    public static List<Component> getTooltip(CompoundTag compound) {
        IMutation<?> mutation = ItemResearchNote.getEncodedMutation(compound);
        if (mutation == null) {
            return List.of();
        }
        ArrayList<Component> tooltips = new ArrayList<Component>();
        MutableComponent species1 = Component.m_237113_((String)"'").m_7220_((Component)mutation.getFirstParent().getDisplayName()).m_130946_("'").m_130940_(ChatFormatting.YELLOW);
        MutableComponent species2 = Component.m_237113_((String)"'").m_7220_((Component)mutation.getSecondParent().getDisplayName()).m_130946_("'").m_130940_(ChatFormatting.YELLOW);
        String mutationChanceKey = EnumMutateChance.rateChance(mutation.getChance()).toString().toLowerCase(Locale.ENGLISH);
        MutableComponent mutationChance = Component.m_237115_((String)("for.researchNote.chance." + mutationChanceKey)).m_130940_(ChatFormatting.BLUE);
        MutableComponent speciesResult = mutation.getResult().getDisplayName().m_6881_().m_130940_(ChatFormatting.LIGHT_PURPLE);
        tooltips.add((Component)Component.m_237115_((String)"for.researchNote.discovery.0"));
        tooltips.add((Component)Component.m_237110_((String)"for.researchNote.discovery.1", (Object[])new Object[]{species1, species2}).m_130940_(ChatFormatting.GRAY));
        tooltips.add((Component)Component.m_237110_((String)"for.researchNote.discovery.2", (Object[])new Object[]{mutationChance}).m_130940_(ChatFormatting.GRAY));
        tooltips.add((Component)Component.m_237110_((String)"for.researchNote.discovery.3", (Object[])new Object[]{speciesResult}).m_130940_(ChatFormatting.GRAY));
        if (!mutation.getSpecialConditions().isEmpty()) {
            for (Component line : mutation.getSpecialConditions()) {
                tooltips.add((Component)line.m_6881_().m_130940_(ChatFormatting.GOLD));
            }
        }
        return tooltips;
    }

    public static boolean registerResults(Level level, Player player, CompoundTag compound) {
        IMutation<?> encoded = ItemResearchNote.getEncodedMutation(compound);
        if (encoded == null) {
            return false;
        }
        IBreedingTracker tracker = encoded.getType().getBreedingTracker((LevelAccessor)level, player.m_36316_());
        if (tracker.isResearched(encoded)) {
            player.m_213846_((Component)Component.m_237115_((String)"for.chat.cannotmemorizeagain"));
            return false;
        }
        Object speciesFirst = encoded.getFirstParent();
        Object speciesSecond = encoded.getSecondParent();
        Object speciesResult = encoded.getResult();
        tracker.registerSpecies((ISpecies<?>)speciesFirst);
        tracker.registerSpecies((ISpecies<?>)speciesSecond);
        tracker.registerSpecies((ISpecies<?>)speciesResult);
        tracker.researchMutation(encoded);
        player.m_213846_((Component)Component.m_237115_((String)"for.chat.memorizednote"));
        player.m_213846_((Component)Component.m_237110_((String)"for.chat.memorizednote2", (Object[])new Object[]{speciesFirst.getDisplayName().m_130940_(ChatFormatting.GRAY), speciesSecond.getDisplayName().m_130940_(ChatFormatting.GRAY), speciesResult.getDisplayName().m_130940_(ChatFormatting.GREEN)}));
        return true;
    }

    public static ResearchNote createMutationNote(GameProfile researcher, IMutation<?> mutation) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_(TYPE_KEY, mutation.getType().id().toString());
        compound.m_128359_(PARENT_0_KEY, mutation.getFirstParent().id().toString());
        compound.m_128359_(PARENT_1_KEY, mutation.getSecondParent().id().toString());
        compound.m_128359_(RESULT_KEY, mutation.getResult().id().toString());
        return new ResearchNote(researcher, compound);
    }

    public static ItemStack createMutationNoteStack(GameProfile researcher, IMutation<?> mutation) {
        ResearchNote note = ItemResearchNote.createMutationNote(researcher, mutation);
        CompoundTag compound = new CompoundTag();
        note.writeToNBT(compound);
        ItemStack created = new ItemStack((ItemLike)CoreItems.RESEARCH_NOTE.item());
        created.m_41751_(compound);
        return created;
    }

    public static class ResearchNote {
        @Nullable
        private final GameProfile researcher;
        private final CompoundTag inner;

        public ResearchNote(GameProfile researcher, CompoundTag inner) {
            this.researcher = researcher;
            this.inner = inner;
        }

        public ResearchNote(@Nullable CompoundTag nbt) {
            if (nbt != null) {
                this.researcher = nbt.m_128441_(ItemResearchNote.RESEARCHER_KEY) ? NbtUtils.m_129228_((CompoundTag)nbt.m_128469_(ItemResearchNote.RESEARCHER_KEY)) : null;
                this.inner = nbt.m_128469_(ItemResearchNote.NBT_INNER);
            } else {
                this.researcher = null;
                this.inner = new CompoundTag();
            }
        }

        public CompoundTag writeToNBT(CompoundTag compound) {
            if (this.researcher != null) {
                CompoundTag nbt = new CompoundTag();
                NbtUtils.m_129230_((CompoundTag)nbt, (GameProfile)this.researcher);
                compound.m_128365_(ItemResearchNote.RESEARCHER_KEY, (Tag)nbt);
            }
            compound.m_128365_(ItemResearchNote.NBT_INNER, (Tag)this.inner);
            return compound;
        }

        public void addTooltip(List<Component> list) {
            List<Component> tooltips = ItemResearchNote.getTooltip(this.inner);
            if (tooltips.isEmpty()) {
                list.add((Component)Component.m_237115_((String)"for.researchNote.error.0").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.ITALIC}));
                list.add((Component)Component.m_237115_((String)"for.researchNote.error.1"));
                return;
            }
            list.addAll(tooltips);
        }
    }
}

