/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.mojang.authlib.GameProfile;
import forestry.api.IForestryApi;
import forestry.api.core.IErrorLogic;
import forestry.api.core.IErrorLogicSource;
import forestry.api.core.ILocationProvider;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.inventory.FakeInventoryAdapter;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.multiblock.MultiblockControllerBase;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class MultiblockControllerForestry
extends MultiblockControllerBase
implements WorldlyContainer,
IOwnedTile,
IErrorLogicSource,
ILocationProvider {
    private final OwnerHandler ownerHandler = new OwnerHandler();
    private final IErrorLogic errorLogic = IForestryApi.INSTANCE.getErrorManager().createErrorLogic();

    protected MultiblockControllerForestry(Level world) {
        super(world);
    }

    @Override
    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return this.errorLogic;
    }

    @Override
    public Level getWorldObj() {
        return this.level;
    }

    @Override
    protected void onMachineAssembled() {
        super.onMachineAssembled();
        if (this.level.f_46443_) {
            return;
        }
        HashMultiset owners = HashMultiset.create();
        for (IMultiblockComponent part : this.connectedParts) {
            GameProfile owner = part.getOwner();
            if (owner == null) continue;
            owners.add((Object)owner);
        }
        GameProfile owner = null;
        int max = 0;
        for (Multiset.Entry entry : owners.entrySet()) {
            int count = entry.getCount();
            if (count <= max) continue;
            max = count;
            owner = (GameProfile)entry.getElement();
        }
        if (owner != null) {
            this.getOwnerHandler().setOwner(owner);
        }
    }

    @Override
    public CompoundTag write(CompoundTag data) {
        this.ownerHandler.write(data);
        return data;
    }

    @Override
    public void read(CompoundTag data) {
        this.ownerHandler.read(data);
    }

    public IInventoryAdapter getInternalInventory() {
        return FakeInventoryAdapter.INSTANCE;
    }

    public void m_6596_() {
        this.getInternalInventory().m_6596_();
    }

    public final int m_6643_() {
        return this.getInternalInventory().m_6643_();
    }

    public final ItemStack m_8020_(int slotIndex) {
        return this.getInternalInventory().m_8020_(slotIndex);
    }

    public final ItemStack m_7407_(int slotIndex, int amount) {
        return this.getInternalInventory().m_7407_(slotIndex, amount);
    }

    public ItemStack m_8016_(int slotIndex) {
        return this.getInternalInventory().m_8016_(slotIndex);
    }

    public final void m_6836_(int slotIndex, ItemStack itemstack) {
        this.getInternalInventory().m_6836_(slotIndex, itemstack);
    }

    public final int m_6893_() {
        return this.getInternalInventory().m_6893_();
    }

    public final void m_5856_(Player player) {
        this.getInternalInventory().m_5856_(player);
    }

    public final void m_5785_(Player player) {
        this.getInternalInventory().m_5785_(player);
    }

    public final boolean m_6542_(Player player) {
        return this.getInternalInventory().m_6542_(player);
    }

    public final boolean m_7013_(int slotIndex, ItemStack itemStack) {
        return this.getInternalInventory().m_7013_(slotIndex, itemStack);
    }

    public int[] m_7071_(Direction side) {
        return this.getInternalInventory().m_7071_(side);
    }

    public final boolean m_7155_(int slotIndex, ItemStack itemStack, Direction side) {
        return this.getInternalInventory().m_7155_(slotIndex, itemStack, side);
    }

    public final boolean m_7157_(int slotIndex, ItemStack itemStack, Direction side) {
        return this.getInternalInventory().m_7157_(slotIndex, itemStack, side);
    }

    public void m_6211_() {
        this.getInternalInventory().m_6211_();
    }

    public boolean m_7983_() {
        return this.getInternalInventory().m_7983_();
    }
}

