/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.api.multiblock.IMultiblockLogic;
import forestry.core.tiles.TileUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkSource;

public class MultiblockUtil {
    public static List<IMultiblockComponent> getNeighboringParts(Level world, IMultiblockComponent part) {
        BlockPos partCoord = part.getCoordinates();
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>(Direction.values().length);
        for (Direction facing : Direction.values()) {
            BlockPos neighborCoord = new BlockPos((Vec3i)partCoord);
            neighborCoord = neighborCoord.m_121945_(facing);
            neighbors.add(neighborCoord);
        }
        ArrayList<IMultiblockComponent> neighborParts = new ArrayList<IMultiblockComponent>();
        ChunkSource chunkProvider = world.m_7726_();
        for (BlockPos neighbor : neighbors) {
            if (!chunkProvider.m_5563_(neighbor.m_123341_() >> 4, neighbor.m_123343_() >> 4)) continue;
            TileUtil.actOnTile((LevelReader)world, neighbor, IMultiblockComponent.class, neighborParts::add);
        }
        return neighborParts;
    }

    @Nullable
    public static <C extends IMultiblockComponent> C getComponent(BlockGetter world, BlockPos pos, Class<C> componentClass) {
        return (C)((IMultiblockComponent)TileUtil.getTile(world, pos, componentClass));
    }

    @Nullable
    public static <C extends IMultiblockComponent, L extends IMultiblockLogic> L getLogic(BlockGetter world, BlockPos pos, Class<C> componentClass) {
        C component = MultiblockUtil.getComponent(world, pos, componentClass);
        if (component == null) {
            return null;
        }
        return (L)component.getMultiblockLogic();
    }

    @Nullable
    public static <C extends IMultiblockComponent, L extends IMultiblockLogic, M extends IMultiblockController> M getController(BlockGetter world, BlockPos pos, Class<C> componentClass) {
        L logic = MultiblockUtil.getLogic(world, pos, componentClass);
        if (logic == null || !logic.isConnected()) {
            return null;
        }
        return (M)logic.getController();
    }
}

