/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import forestry.Forestry;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockLogic;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockLogic;
import forestry.core.multiblock.MultiblockUtil;
import forestry.core.tiles.TileUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkSource;

public class MultiblockWorldRegistry {
    private final Level world;
    private final Set<IMultiblockControllerInternal> controllers;
    private final Set<IMultiblockControllerInternal> dirtyControllers;
    private final Set<IMultiblockControllerInternal> deadControllers;
    private Set<IMultiblockComponent> orphanedParts;
    private final Set<IMultiblockComponent> detachedParts;
    private final Long2ObjectMap<Set<IMultiblockComponent>> partsAwaitingChunkLoad;
    private final Object partsAwaitingChunkLoadMutex;
    private final Object orphanedPartsMutex;

    public MultiblockWorldRegistry(Level world) {
        this.world = world;
        this.controllers = new HashSet<IMultiblockControllerInternal>();
        this.deadControllers = new HashSet<IMultiblockControllerInternal>();
        this.dirtyControllers = new HashSet<IMultiblockControllerInternal>();
        this.detachedParts = new HashSet<IMultiblockComponent>();
        this.orphanedParts = new HashSet<IMultiblockComponent>();
        this.partsAwaitingChunkLoad = new Long2ObjectOpenHashMap();
        this.partsAwaitingChunkLoadMutex = new Object();
        this.orphanedPartsMutex = new Object();
    }

    public void tickStart() {
        if (!this.controllers.isEmpty()) {
            for (IMultiblockControllerInternal controller : this.controllers) {
                if (controller.getWorldObj() != this.world || controller.getWorldObj().f_46443_ != this.world.f_46443_) continue;
                if (controller.hasNoParts()) {
                    this.deadControllers.add(controller);
                    continue;
                }
                controller.updateMultiblockEntity();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMultiblockChanges() {
        ChunkSource chunkProvider = this.world.m_7726_();
        ArrayList<Set<IMultiblockControllerInternal>> mergePools = null;
        if (!this.orphanedParts.isEmpty()) {
            Set<IMultiblockComponent> orphansToProcess = null;
            Object object = this.orphanedPartsMutex;
            synchronized (object) {
                if (!this.orphanedParts.isEmpty()) {
                    orphansToProcess = this.orphanedParts;
                    this.orphanedParts = new HashSet<IMultiblockComponent>();
                }
            }
            if (orphansToProcess != null && !orphansToProcess.isEmpty()) {
                for (IMultiblockComponent orphan : orphansToProcess) {
                    BlockEntity entity;
                    BlockPos coord = orphan.getCoordinates();
                    if (!chunkProvider.m_5563_(coord.m_123341_() >> 4, coord.m_123343_() >> 4) || orphan instanceof BlockEntity && (entity = (BlockEntity)orphan).m_58901_() || TileUtil.getTile((BlockGetter)this.world, coord) != orphan) continue;
                    Set<IMultiblockControllerInternal> set = this.attachToNeighbors(orphan);
                    if (set.isEmpty()) {
                        MultiblockLogic logic = (MultiblockLogic)orphan.getMultiblockLogic();
                        Object newController = logic.createNewController(this.world);
                        newController.attachBlock(orphan);
                        this.controllers.add((IMultiblockControllerInternal)newController);
                        continue;
                    }
                    if (set.size() <= 1) continue;
                    if (mergePools == null) {
                        mergePools = new ArrayList<Set<IMultiblockControllerInternal>>();
                    }
                    ArrayList<Set> candidatePools = new ArrayList<Set>();
                    for (Set set2 : mergePools) {
                        if (Collections.disjoint(set2, set)) continue;
                        candidatePools.add(set2);
                    }
                    if (candidatePools.isEmpty()) {
                        mergePools.add(set);
                        continue;
                    }
                    if (candidatePools.size() == 1) {
                        ((Set)candidatePools.get(0)).addAll(set);
                        continue;
                    }
                    Set masterPool = (Set)candidatePools.get(0);
                    for (int i = 1; i < candidatePools.size(); ++i) {
                        Set set3 = (Set)candidatePools.get(i);
                        masterPool.addAll(set3);
                        mergePools.remove(set3);
                    }
                    masterPool.addAll(set);
                }
            }
        }
        if (mergePools != null && !mergePools.isEmpty()) {
            for (Set set : mergePools) {
                IMultiblockControllerInternal newMaster = null;
                for (IMultiblockControllerInternal controller : set) {
                    if (newMaster != null && !controller.shouldConsume(newMaster)) continue;
                    newMaster = controller;
                }
                if (newMaster == null) {
                    Forestry.LOGGER.error("Multiblock system checked a merge pool of size {}, found no master candidates. This should never happen.", (Object)set.size());
                    continue;
                }
                this.addDirtyController(newMaster);
                for (IMultiblockControllerInternal controller : set) {
                    if (controller == newMaster) continue;
                    newMaster.assimilate(controller);
                    this.addDeadController(controller);
                    this.addDirtyController(newMaster);
                }
            }
        }
        if (!this.dirtyControllers.isEmpty()) {
            for (IMultiblockControllerInternal iMultiblockControllerInternal : this.dirtyControllers) {
                if (iMultiblockControllerInternal == null) continue;
                Set<IMultiblockComponent> newlyDetachedParts = iMultiblockControllerInternal.checkForDisconnections();
                if (!iMultiblockControllerInternal.hasNoParts()) {
                    iMultiblockControllerInternal.recalculateMinMaxCoords();
                    iMultiblockControllerInternal.checkIfMachineIsWhole();
                } else {
                    this.addDeadController(iMultiblockControllerInternal);
                }
                if (newlyDetachedParts.isEmpty()) continue;
                this.detachedParts.addAll(newlyDetachedParts);
            }
            this.dirtyControllers.clear();
        }
        if (!this.deadControllers.isEmpty()) {
            for (IMultiblockControllerInternal iMultiblockControllerInternal : this.deadControllers) {
                BlockPos destroyedCoord;
                if (!iMultiblockControllerInternal.hasNoParts()) {
                    Forestry.LOGGER.error("Found a non-empty controller. Forcing it to shed its blocks and die. This should never happen!");
                    this.detachedParts.addAll(iMultiblockControllerInternal.detachAllBlocks());
                }
                if ((destroyedCoord = iMultiblockControllerInternal.getDestroyedCoord()) != null) {
                    iMultiblockControllerInternal.onDestroyed(destroyedCoord);
                }
                this.controllers.remove(iMultiblockControllerInternal);
            }
            this.deadControllers.clear();
        }
        for (IMultiblockComponent iMultiblockComponent : this.detachedParts) {
            MultiblockLogic logic = (MultiblockLogic)iMultiblockComponent.getMultiblockLogic();
            logic.assertDetached(iMultiblockComponent);
        }
        this.addAllOrphanedPartsThreadsafe(this.detachedParts);
        this.detachedParts.clear();
    }

    private Set<IMultiblockControllerInternal> attachToNeighbors(IMultiblockComponent part) {
        HashSet<IMultiblockControllerInternal> controllers = new HashSet<IMultiblockControllerInternal>();
        IMultiblockControllerInternal bestController = null;
        MultiblockLogic logic = (MultiblockLogic)part.getMultiblockLogic();
        Class controllerClass = logic.getControllerClass();
        List<IMultiblockComponent> partsToCheck = MultiblockUtil.getNeighboringParts(this.world, part);
        for (IMultiblockComponent neighborPart : partsToCheck) {
            IMultiblockControllerInternal candidate;
            IMultiblockLogic neighborLogic = neighborPart.getMultiblockLogic();
            if (!neighborLogic.isConnected() || !controllerClass.isAssignableFrom((candidate = (IMultiblockControllerInternal)neighborLogic.getController()).getClass())) continue;
            if (!controllers.contains(candidate) && (bestController == null || candidate.shouldConsume(bestController))) {
                bestController = candidate;
            }
            controllers.add(candidate);
        }
        if (bestController != null) {
            bestController.attachBlock(part);
        }
        return controllers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPartAdded(IMultiblockComponent part) {
        BlockPos worldLocation = part.getCoordinates();
        if (!this.world.m_7726_().m_5563_(worldLocation.m_123341_() >> 4, worldLocation.m_123343_() >> 4)) {
            long chunkHash = ChunkPos.m_45589_((int)(worldLocation.m_123341_() >> 4), (int)(worldLocation.m_123343_() >> 4));
            Object object = this.partsAwaitingChunkLoadMutex;
            synchronized (object) {
                Set<IMultiblockComponent> partSet;
                if (!this.partsAwaitingChunkLoad.containsKey(chunkHash)) {
                    partSet = new HashSet();
                    this.partsAwaitingChunkLoad.put(chunkHash, partSet);
                } else {
                    partSet = (Set)this.partsAwaitingChunkLoad.get(chunkHash);
                }
                partSet.add(part);
            }
        } else {
            this.addOrphanedPartThreadsafe(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPartRemovedFromWorld(IMultiblockComponent part) {
        Object object;
        BlockPos coord = part.getCoordinates();
        long hash = ChunkPos.m_45589_((int)(coord.m_123341_() >> 4), (int)(coord.m_123343_() >> 4));
        if (this.partsAwaitingChunkLoad.containsKey(hash)) {
            object = this.partsAwaitingChunkLoadMutex;
            synchronized (object) {
                if (this.partsAwaitingChunkLoad.containsKey(hash)) {
                    ((Set)this.partsAwaitingChunkLoad.get(hash)).remove(part);
                    if (((Set)this.partsAwaitingChunkLoad.get(hash)).size() <= 0) {
                        this.partsAwaitingChunkLoad.remove(hash);
                    }
                }
            }
        }
        this.detachedParts.remove(part);
        if (this.orphanedParts.contains(part)) {
            object = this.orphanedPartsMutex;
            synchronized (object) {
                this.orphanedParts.remove(part);
            }
        }
        MultiblockLogic logic = (MultiblockLogic)part.getMultiblockLogic();
        logic.assertDetached(part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWorldUnloaded() {
        this.controllers.clear();
        this.deadControllers.clear();
        this.dirtyControllers.clear();
        this.detachedParts.clear();
        Object object = this.partsAwaitingChunkLoadMutex;
        synchronized (object) {
            this.partsAwaitingChunkLoad.clear();
        }
        object = this.orphanedPartsMutex;
        synchronized (object) {
            this.orphanedParts.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChunkLoaded(int chunkX, int chunkZ) {
        long chunkHash = ChunkPos.m_45589_((int)chunkX, (int)chunkZ);
        if (this.partsAwaitingChunkLoad.containsKey(chunkHash)) {
            Object object = this.partsAwaitingChunkLoadMutex;
            synchronized (object) {
                if (this.partsAwaitingChunkLoad.containsKey(chunkHash)) {
                    this.addAllOrphanedPartsThreadsafe((Collection)this.partsAwaitingChunkLoad.get(chunkHash));
                    this.partsAwaitingChunkLoad.remove(chunkHash);
                }
            }
        }
    }

    public void addDeadController(IMultiblockControllerInternal deadController) {
        this.deadControllers.add(deadController);
    }

    public void addDirtyController(IMultiblockControllerInternal dirtyController) {
        this.dirtyControllers.add(dirtyController);
    }

    public Set<IMultiblockControllerInternal> getControllers() {
        return Collections.unmodifiableSet(this.controllers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrphanedPartThreadsafe(IMultiblockComponent part) {
        Object object = this.orphanedPartsMutex;
        synchronized (object) {
            this.orphanedParts.add(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllOrphanedPartsThreadsafe(Collection<? extends IMultiblockComponent> parts) {
        if (parts.isEmpty()) {
            return;
        }
        Object object = this.orphanedPartsMutex;
        synchronized (object) {
            this.orphanedParts.addAll(parts);
        }
    }
}

