/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.multiblock.IMultiblockSizeLimits;
import forestry.core.multiblock.MultiblockControllerForestry;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.tiles.TileUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public abstract class RectangularMultiblockControllerBase
extends MultiblockControllerForestry {
    private final IMultiblockSizeLimits sizeLimits;

    protected RectangularMultiblockControllerBase(Level world, IMultiblockSizeLimits sizeLimits) {
        super(world);
        this.sizeLimits = sizeLimits;
    }

    @Override
    protected void isMachineWhole() throws MultiblockValidationException {
        int minX = this.sizeLimits.getMinimumXSize();
        int minY = this.sizeLimits.getMinimumYSize();
        int minZ = this.sizeLimits.getMinimumZSize();
        if (this.connectedParts.size() < this.sizeLimits.getMinimumNumberOfBlocksForAssembledMachine()) {
            throw new MultiblockValidationException(Component.m_237110_((String)"for.multiblock.error.small", (Object[])new Object[]{minX, minY, minZ}).getString());
        }
        BlockPos maximumCoord = this.getMaximumCoord();
        BlockPos minimumCoord = this.getMinimumCoord();
        int deltaX = maximumCoord.m_123341_() - minimumCoord.m_123341_() + 1;
        int deltaY = maximumCoord.m_123342_() - minimumCoord.m_123342_() + 1;
        int deltaZ = maximumCoord.m_123343_() - minimumCoord.m_123343_() + 1;
        int maxX = this.sizeLimits.getMaximumXSize();
        int maxY = this.sizeLimits.getMaximumYSize();
        int maxZ = this.sizeLimits.getMaximumZSize();
        if (maxX > 0 && deltaX > maxX) {
            throw new MultiblockValidationException(Component.m_237110_((String)"for.multiblock.error.large.x", (Object[])new Object[]{maxX}).getString());
        }
        if (maxY > 0 && deltaY > maxY) {
            throw new MultiblockValidationException(Component.m_237110_((String)"for.multiblock.error.large.y", (Object[])new Object[]{maxY}).getString());
        }
        if (maxZ > 0 && deltaZ > maxZ) {
            throw new MultiblockValidationException(Component.m_237110_((String)"for.multiblock.error.large.z", (Object[])new Object[]{maxZ}).getString());
        }
        if (deltaX < minX) {
            throw new MultiblockValidationException(Component.m_237110_((String)"for.multiblock.error.small.x", (Object[])new Object[]{minX}).getString());
        }
        if (deltaY < minY) {
            throw new MultiblockValidationException(Component.m_237110_((String)"for.multiblock.error.small.y", (Object[])new Object[]{minY}).getString());
        }
        if (deltaZ < minZ) {
            throw new MultiblockValidationException(Component.m_237110_((String)"for.multiblock.error.small.z", (Object[])new Object[]{minZ}).getString());
        }
        Class<?> myClass = this.getClass();
        for (int x = minimumCoord.m_123341_(); x <= maximumCoord.m_123341_(); ++x) {
            for (int y = minimumCoord.m_123342_(); y <= maximumCoord.m_123342_(); ++y) {
                for (int z = minimumCoord.m_123343_(); z <= maximumCoord.m_123343_(); ++z) {
                    IMultiblockComponent part;
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockEntity te = TileUtil.getTile((BlockGetter)this.level, pos);
                    if (te instanceof IMultiblockComponent) {
                        part = (IMultiblockComponent)te;
                        if (!myClass.equals(part.getMultiblockLogic().getController().getClass())) {
                            throw new MultiblockValidationException(Component.m_237110_((String)"for.multiblock.error.invalid.part", (Object[])new Object[]{Component.m_237115_((String)this.getUnlocalizedType()).getString()}).getString());
                        }
                    } else {
                        part = null;
                    }
                    int extremes = 0;
                    if (x == minimumCoord.m_123341_()) {
                        ++extremes;
                    }
                    if (y == minimumCoord.m_123342_()) {
                        ++extremes;
                    }
                    if (z == minimumCoord.m_123343_()) {
                        ++extremes;
                    }
                    if (x == maximumCoord.m_123341_()) {
                        ++extremes;
                    }
                    if (y == maximumCoord.m_123342_()) {
                        ++extremes;
                    }
                    if (z == maximumCoord.m_123343_()) {
                        ++extremes;
                    }
                    if (extremes >= 1) {
                        int exteriorLevel = y - minimumCoord.m_123342_();
                        if (part != null) {
                            this.isGoodForExteriorLevel(part, exteriorLevel);
                            continue;
                        }
                        this.isBlockGoodForExteriorLevel(exteriorLevel, this.level, pos);
                        continue;
                    }
                    if (part != null) {
                        this.isGoodForInterior(part);
                        continue;
                    }
                    this.isBlockGoodForInterior(this.level, pos);
                }
            }
        }
    }

    protected IMultiblockSizeLimits getSizeLimits() {
        return this.sizeLimits;
    }

    protected abstract void isGoodForExteriorLevel(IMultiblockComponent var1, int var2) throws MultiblockValidationException;

    protected abstract void isGoodForInterior(IMultiblockComponent var1) throws MultiblockValidationException;
}

