/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import forestry.api.ForestryConstants;
import forestry.core.blocks.BlockBase;
import forestry.core.render.ForestryModelLayers;
import forestry.core.tiles.TileEscritoire;
import forestry.core.utils.RenderUtil;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class RenderEscritoire
implements BlockEntityRenderer<TileEscritoire> {
    private static final ResourceLocation TEXTURE = ForestryConstants.forestry("textures/block/escritoire.png");
    private final ItemRenderer itemRenderer;
    private final ModelPart root;

    public RenderEscritoire(BlockEntityRendererProvider.Context ctx) {
        this.itemRenderer = ctx.m_234447_();
        this.root = ctx.m_173582_(ForestryModelLayers.ESCRITOIRE_LAYER);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("desk", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 16.0f, 2.0f, 15.0f).m_171480_(), PartPose.m_171423_((float)0.0f, (float)9.5f, (float)0.4f, (float)0.0872665f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("standrb", CubeListBuilder.m_171558_().m_171514_(38, 18).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 6.0f, 2.0f).m_171480_(), PartPose.m_171419_((float)13.0f, (float)4.0f, (float)13.0f));
        partdefinition.m_171599_("standrf", CubeListBuilder.m_171558_().m_171514_(38, 18).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 6.0f, 2.0f).m_171480_(), PartPose.m_171419_((float)13.0f, (float)4.0f, (float)1.0f));
        partdefinition.m_171599_("standlb", CubeListBuilder.m_171558_().m_171514_(38, 18).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 6.0f, 2.0f).m_171480_(), PartPose.m_171419_((float)1.0f, (float)4.0f, (float)1.0f));
        partdefinition.m_171599_("standlf", CubeListBuilder.m_171558_().m_171514_(38, 18).m_171481_(0.0f, 0.0f, 0.0f, 2.0f, 6.0f, 2.0f).m_171480_(), PartPose.m_171419_((float)1.0f, (float)4.0f, (float)13.0f));
        partdefinition.m_171599_("drawers", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171481_(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 3.0f).m_171480_(), PartPose.m_171419_((float)0.5f, (float)11.0f, (float)0.5f));
        partdefinition.m_171599_("standlowrb", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 4.0f, 1.0f).m_171480_(), PartPose.m_171419_((float)13.5f, (float)0.0f, (float)13.5f));
        partdefinition.m_171599_("standlowrf", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 4.0f, 1.0f).m_171480_(), PartPose.m_171419_((float)13.5f, (float)0.0f, (float)1.5f));
        partdefinition.m_171599_("standlowlb", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 4.0f, 1.0f).m_171480_(), PartPose.m_171419_((float)1.5f, (float)0.0f, (float)1.5f));
        partdefinition.m_171599_("standlowlf", CubeListBuilder.m_171558_().m_171514_(0, 26).m_171481_(0.0f, 0.0f, 0.0f, 1.0f, 4.0f, 1.0f).m_171480_(), PartPose.m_171419_((float)1.5f, (float)0.0f, (float)13.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void render(TileEscritoire escritoire, float partialTick, PoseStack stack, MultiBufferSource buffers, int light, int overlay) {
        stack.m_85836_();
        Direction facing = (Direction)escritoire.m_58900_().m_61143_(BlockBase.FACING);
        RenderUtil.rotateByHorizontalDirection(stack, facing);
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_110452_((ResourceLocation)TEXTURE));
        this.root.m_104301_(stack, buffer, light, overlay);
        ItemStack displayStack = escritoire.getIndividualOnDisplay();
        if (!displayStack.m_41619_()) {
            stack.m_85836_();
            stack.m_85837_(0.5, 0.65, 0.5);
            stack.m_85841_(0.75f, 0.75f, 0.75f);
            RenderUtil.renderDisplayStack(stack, this.itemRenderer, displayStack, escritoire.m_58904_(), partialTick, buffers, light);
            stack.m_85849_();
        }
        stack.m_85849_();
    }
}

