/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import java.util.Calendar;
import net.minecraft.network.chat.Component;

public record DayMonth(int day, int month) {
    public static DayMonth now() {
        Calendar calendar = Calendar.getInstance();
        return new DayMonth(calendar.get(5), calendar.get(2) + 1);
    }

    public boolean between(DayMonth start, DayMonth end) {
        if (this.equals(start) || this.equals(end)) {
            return true;
        }
        if (start.month > end.month) {
            return this.after(start) || this.before(end);
        }
        return this.after(start) && this.before(end);
    }

    public boolean before(DayMonth other) {
        if (other.month > this.month) {
            return true;
        }
        if (other.month < this.month) {
            return false;
        }
        return this.day < other.day;
    }

    public boolean after(DayMonth other) {
        if (other.month < this.month) {
            return true;
        }
        if (other.month > this.month) {
            return false;
        }
        return this.day > other.day;
    }

    public Component getDisplayName() {
        return Component.m_237110_((String)("forestry.date.month." + this.month), (Object[])new Object[]{this.day});
    }
}

