/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.FakePlayerFactory;

public abstract class PlayerUtil {
    private static final UUID emptyUUID = new UUID(0L, 0L);

    public static boolean isSameGameProfile(GameProfile player1, GameProfile player2) {
        UUID id1 = player1.getId();
        UUID id2 = player2.getId();
        if (id1 != null && id2 != null && !id1.equals(emptyUUID) && !id2.equals(emptyUUID)) {
            return id1.equals(id2);
        }
        return player1.getName() != null && player1.getName().equals(player2.getName());
    }

    public static String getOwnerName(@Nullable GameProfile profile) {
        if (profile == null) {
            return Component.m_237115_((String)"for.gui.derelict").getString();
        }
        return profile.getName();
    }

    @Nullable
    public static Player getPlayer(Level world, @Nullable GameProfile profile) {
        if (profile == null || profile.getName() == null) {
            if (world instanceof ServerLevel) {
                return FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)world));
            }
            return null;
        }
        Player player = world.m_46003_(profile.getId());
        if (player == null && world instanceof ServerLevel) {
            player = FakePlayerFactory.get((ServerLevel)((ServerLevel)world), (GameProfile)profile);
        }
        return player;
    }

    @Nullable
    public static Player getFakePlayer(Level world, @Nullable GameProfile profile) {
        if (profile == null || profile.getName() == null) {
            if (world instanceof ServerLevel) {
                return FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)world));
            }
            return null;
        }
        if (world instanceof ServerLevel) {
            return FakePlayerFactory.get((ServerLevel)((ServerLevel)world), (GameProfile)profile);
        }
        return null;
    }
}

