/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import forestry.api.arboriculture.ITreeSpecies;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.apiculture.ModuleApiculture;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.core.utils.SpeciesUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class TreeUtil {
    @Nullable
    public static ITree getTreeSafe(LevelAccessor level, BlockPos pos) {
        if (!level.m_46805_(pos)) {
            return null;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileLeaves) {
            TileLeaves leaves = (TileLeaves)blockEntity;
            return leaves.getTree();
        }
        BlockState state = level.m_8055_(pos);
        return ((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).getVanillaIndividual(state);
    }

    public static boolean canCreateNursery(LevelAccessor world, BlockPos pos) {
        return TreeUtil.getTreeSafe(world, pos) != null;
    }

    @Nullable
    public static IButterflyNursery getNursery(LevelAccessor level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IButterflyNursery) {
            IButterflyNursery nursery = (IButterflyNursery)blockEntity;
            return nursery;
        }
        return null;
    }

    @Nullable
    public static IButterflyNursery getOrCreateNursery(LevelAccessor level, BlockPos pos, boolean convertVanilla) {
        IButterflyNursery nursery = TreeUtil.getNursery(level, pos);
        if (nursery == null && convertVanilla) {
            return TreeUtil.getOrCreateLeaves(level, pos, true);
        }
        return nursery;
    }

    @Nullable
    public static TileLeaves getOrCreateLeaves(LevelAccessor level, BlockPos pos, boolean convertVanilla) {
        ITree tree;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileLeaves) {
            TileLeaves leaves = (TileLeaves)blockEntity;
            return leaves;
        }
        if (convertVanilla && (tree = TreeUtil.getTreeSafe(level, pos)) != null) {
            ITreeSpecies species = tree.getSpecies();
            species.setLeaves(tree.getGenome(), level, pos, level.m_213780_(), true);
            BlockEntity blockEntity2 = level.m_7702_(pos);
            if (blockEntity2 instanceof TileLeaves) {
                TileLeaves leaves = (TileLeaves)blockEntity2;
                return leaves;
            }
        }
        return null;
    }

    public static boolean tryMate(TileLeaves leaves, ITree pollen) {
        ITree tree = leaves.getTree();
        if (TreeUtil.canMate(tree, pollen)) {
            tree.setMate(pollen.getGenome());
            leaves.sendNetworkUpdate();
            return true;
        }
        return false;
    }

    public static boolean canMate(@Nullable ITree leaves, ITree pollen) {
        return leaves != null && leaves.getMate() == null && (ModuleApiculture.doSelfPollination || !leaves.getGenome().isSameAlleles(pollen.getGenome()));
    }
}

