/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.fabricator;

import forestry.api.ForestryConstants;
import forestry.api.recipes.IFabricatorRecipe;
import forestry.api.recipes.IFabricatorSmeltingRecipe;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.recipes.jei.ForestryRecipeType;
import forestry.core.utils.JeiUtil;
import forestry.core.utils.RecipeUtils;
import forestry.factory.blocks.BlockTypeFactoryPlain;
import forestry.factory.features.FactoryBlocks;
import forestry.factory.features.FactoryRecipeTypes;
import forestry.modules.features.FeatureBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.ICraftingGridHelper;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FabricatorRecipeCategory
extends ForestryRecipeCategory<IFabricatorRecipe> {
    private static final ResourceLocation guiTexture = ForestryConstants.forestry("textures/gui/fabricator.png");
    private final IDrawable icon;
    @Nullable
    private final ICraftingGridHelper craftingGridHelper;

    public FabricatorRecipeCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createDrawable(guiTexture, 20, 16, 136, 54), "block.forestry.fabricator");
        FeatureBlock fabricatorFeatureBlock = (FeatureBlock)FactoryBlocks.PLAIN.get(BlockTypeFactoryPlain.FABRICATOR);
        ItemStack fabricator = new ItemStack(fabricatorFeatureBlock.block());
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)fabricator);
        this.craftingGridHelper = guiHelper.createCraftingGridHelper();
    }

    private static Map<Fluid, List<IFabricatorSmeltingRecipe>> getSmeltingInputs() {
        HashMap<Fluid, List<IFabricatorSmeltingRecipe>> smeltingInputs = new HashMap<Fluid, List<IFabricatorSmeltingRecipe>>();
        RecipeUtils.getRecipes(RecipeUtils.getRecipeManager(), FactoryRecipeTypes.FABRICATOR_SMELTING).forEach(smelting -> {
            Fluid fluid = smelting.getResultFluid().getFluid();
            if (!smeltingInputs.containsKey(fluid)) {
                smeltingInputs.put(fluid, new ArrayList());
            }
            ((List)smeltingInputs.get(fluid)).add(smelting);
        });
        return smeltingInputs;
    }

    public RecipeType<IFabricatorRecipe> getRecipeType() {
        return ForestryRecipeType.FABRICATOR;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, IFabricatorRecipe recipe, IFocusGroup focuses) {
        FluidStack recipeLiquid = recipe.getResultFluid();
        Fluid recipeFluid = recipeLiquid.getFluid();
        List<IFabricatorSmeltingRecipe> smeltingRecipes = FabricatorRecipeCategory.getSmeltingInputs().get(recipeFluid);
        List smeltingInput = smeltingRecipes.stream().flatMap(s -> Arrays.stream(s.getInput().m_43908_())).toList();
        builder.addSlot(RecipeIngredientRole.INPUT, 6, 32).setFluidRenderer(2000L, false, 16, 16).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipeLiquid);
        ShapedRecipe craftingGridRecipe = recipe.getCraftingGridRecipe();
        List<IRecipeSlotBuilder> craftingSlots = JeiUtil.layoutSlotGrid(builder, RecipeIngredientRole.INPUT, 3, 3, 47, 1, 18);
        JeiUtil.setCraftingItems(craftingSlots, (CraftingRecipe)craftingGridRecipe, this.craftingGridHelper);
        builder.addSlot(RecipeIngredientRole.CATALYST, 6, 5).addItemStacks(smeltingInput);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 119, 37).addItemStack(craftingGridRecipe.m_8043_(RecipeUtils.getRegistryAccess()));
    }
}

