/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes.jei.rainmaker;

import forestry.api.fuels.RainSubstrate;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.core.recipes.jei.ForestryRecipeType;
import forestry.factory.blocks.BlockTypeFactoryTesr;
import forestry.factory.features.FactoryBlocks;
import forestry.modules.features.FeatureBlock;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class RainmakerRecipeCategory
extends ForestryRecipeCategory<RainSubstrate> {
    private final IDrawable slot;
    private final IDrawable icon;

    public RainmakerRecipeCategory(IGuiHelper guiHelper) {
        super((IDrawable)guiHelper.createBlankDrawable(150, 30), "block.forestry.rainmaker");
        this.slot = guiHelper.getSlotDrawable();
        ItemStack rainmaker = new ItemStack(((FeatureBlock)FactoryBlocks.TESR.get(BlockTypeFactoryTesr.RAINMAKER)).block());
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)rainmaker);
    }

    public RecipeType<RainSubstrate> getRecipeType() {
        return ForestryRecipeType.RAINMAKER;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, RainSubstrate recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).setBackground(this.slot, -1, -1).addItemStack(recipe.item());
    }

    public void draw(RainSubstrate recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        Component effect = RainmakerRecipeCategory.getEffectString(recipe);
        MutableComponent speed = Component.m_237110_((String)"for.jei.rainmaker.speed", (Object[])new Object[]{Float.valueOf(recipe.speed())});
        Font font = Minecraft.m_91087_().f_91062_;
        graphics.m_280614_(font, effect, 24, 0, 0x404040, false);
        graphics.m_280614_(font, (Component)speed, 24, 10, 0x808080, false);
        if (!recipe.reverse()) {
            MutableComponent duration = Component.m_237110_((String)"for.jei.rainmaker.duration", (Object[])new Object[]{recipe.duration()});
            graphics.m_280614_(font, (Component)duration, 24, 20, 0x808080, false);
        }
    }

    private static Component getEffectString(RainSubstrate recipe) {
        if (recipe.reverse()) {
            return Component.m_237115_((String)"for.jei.rainmaker.stops.rain");
        }
        return Component.m_237115_((String)"for.jei.rainmaker.causes.rain");
    }
}

