/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming;

import forestry.api.farming.HorizontalDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmListener;
import forestry.api.farming.IFarmLogic;
import forestry.core.utils.VecUtil;
import forestry.farming.FarmTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;

public class FarmHelper {
    public static final Comparator<ICrop> TOP_DOWN_COMPARATOR = (o1, o2) -> VecUtil.TOP_DOWN_COMPARATOR.compare(o1.getPosition(), o2.getPosition());

    public static Direction getLayoutDirection(Direction farmSide) {
        return farmSide.m_122428_();
    }

    private static BlockPos getFarmMultiblockCorner(BlockPos start, Direction farmSide, Direction layoutDirection, BlockPos minFarmCoord, BlockPos maxFarmCoord) {
        BlockPos edge = FarmHelper.getFarmMultiblockEdge(start, farmSide, maxFarmCoord, minFarmCoord);
        return FarmHelper.getFarmMultiblockEdge(edge, layoutDirection.m_122424_(), maxFarmCoord, minFarmCoord);
    }

    private static BlockPos getFarmMultiblockEdge(BlockPos start, Direction direction, BlockPos maxFarmCoord, BlockPos minFarmCoord) {
        return switch (direction) {
            case Direction.NORTH -> new BlockPos(start.m_123341_(), start.m_123342_(), minFarmCoord.m_123343_());
            case Direction.EAST -> new BlockPos(maxFarmCoord.m_123341_(), start.m_123342_(), start.m_123343_());
            case Direction.SOUTH -> new BlockPos(start.m_123341_(), start.m_123342_(), maxFarmCoord.m_123343_());
            case Direction.WEST -> new BlockPos(minFarmCoord.m_123341_(), start.m_123342_(), start.m_123343_());
            default -> throw new IllegalArgumentException("Invalid farm direction: " + direction);
        };
    }

    public static void createTargets(Level world, IFarmHousing farmHousing, Map<Direction, List<FarmTarget>> targets, BlockPos targetStart, int allowedExtent, int farmSizeNorthSouth, int farmSizeEastWest, BlockPos minFarmCoord, BlockPos maxFarmCoord) {
        for (Direction farmSide : HorizontalDirection.VALUES) {
            BlockPos groundLocation;
            int farmWidth = farmSide == Direction.NORTH || farmSide == Direction.SOUTH ? farmSizeEastWest : farmSizeNorthSouth;
            int targetMaxLimit = allowedExtent + farmWidth;
            Direction layoutDirection = FarmHelper.getLayoutDirection(farmSide);
            ArrayList<FarmTarget> farmSideTargets = new ArrayList<FarmTarget>();
            targets.put(farmSide, farmSideTargets);
            BlockPos targetLocation = FarmHelper.getFarmMultiblockCorner(targetStart, farmSide, layoutDirection, minFarmCoord, maxFarmCoord);
            BlockPos firstLocation = targetLocation.m_121945_(farmSide);
            BlockPos firstGroundPosition = FarmHelper.getGroundPosition(world, farmHousing, firstLocation);
            if (firstGroundPosition == null) continue;
            int groundHeight = firstGroundPosition.m_123342_();
            for (int i = 0; i < allowedExtent && world.m_46805_(groundLocation = new BlockPos((targetLocation = targetLocation.m_121945_(farmSide)).m_123341_(), groundHeight, targetLocation.m_123343_())) && farmHousing.isValidPlatform(world, groundLocation); ++i) {
                int targetLimit = targetMaxLimit;
                if (!farmHousing.isSquare()) {
                    targetLimit = targetMaxLimit - i - 1;
                }
                FarmTarget target = new FarmTarget(targetLocation, layoutDirection, targetLimit);
                farmSideTargets.add(target);
            }
        }
    }

    @Nullable
    private static BlockPos getGroundPosition(Level world, IFarmHousing farmHousing, BlockPos targetPosition) {
        if (!world.m_46805_(targetPosition)) {
            return null;
        }
        for (int yOffset = 2; yOffset > -4; --yOffset) {
            BlockPos position = targetPosition.m_7918_(0, yOffset, 0);
            if (!world.m_46805_(position) || !farmHousing.isValidPlatform(world, position)) continue;
            return position;
        }
        return null;
    }

    public static boolean isCycleCanceledByListeners(IFarmLogic logic, Direction direction, Iterable<IFarmListener> farmListeners) {
        for (IFarmListener listener : farmListeners) {
            if (!listener.cancelTask(logic, direction)) continue;
            return true;
        }
        return false;
    }

    public static void setExtents(Level world, IFarmHousing farmHousing, Map<Direction, List<FarmTarget>> targets) {
        for (List<FarmTarget> targetsList : targets.values()) {
            if (targetsList.isEmpty()) continue;
            BlockPos groundPosition = FarmHelper.getGroundPosition(world, farmHousing, targetsList.get(0).getStart());
            for (FarmTarget target : targetsList) {
                target.setExtentAndYOffset(world, groundPosition, farmHousing);
            }
        }
    }

    public static boolean cultivateTarget(Level world, IFarmHousing farmHousing, FarmTarget target, IFarmLogic logic, Iterable<IFarmListener> farmListeners) {
        BlockPos targetPosition = target.getStart().m_7918_(0, target.getYOffset(), 0);
        if (logic.cultivate(world, farmHousing, targetPosition, target.getDirection(), target.getExtent())) {
            for (IFarmListener listener : farmListeners) {
                listener.hasCultivated(logic, targetPosition, target.getDirection(), target.getExtent());
            }
            return true;
        }
        return false;
    }

    public static Collection<ICrop> harvestTargets(Level world, IFarmHousing housing, List<FarmTarget> farmTargets, IFarmLogic logic, Iterable<IFarmListener> farmListeners) {
        for (FarmTarget target : farmTargets) {
            Collection<ICrop> harvested = FarmHelper.harvestTarget(world, housing, target, logic, farmListeners);
            if (harvested.isEmpty()) continue;
            return harvested;
        }
        return Collections.emptyList();
    }

    public static Collection<ICrop> harvestTarget(Level world, IFarmHousing housing, FarmTarget target, IFarmLogic logic, Iterable<IFarmListener> farmListeners) {
        BlockPos pos = target.getStart().m_7918_(0, target.getYOffset(), 0);
        Collection<ICrop> harvested = logic.harvest(world, housing, target.getDirection(), target.getExtent(), pos);
        if (!harvested.isEmpty()) {
            for (IFarmListener listener : farmListeners) {
                listener.hasScheduledHarvest(harvested, logic, pos, target.getDirection(), target.getExtent());
            }
        }
        return harvested;
    }
}

