/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.HorizontalDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmType;
import forestry.api.farming.IFarmable;
import forestry.api.farming.Soil;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.FarmLogicSoil;
import forestry.farming.logic.farmables.FarmableCocoa;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class FarmLogicCocoa
extends FarmLogicSoil {
    private static final int[] LAYOUT_POSITIONS = new int[]{4, 1, 3, 0, 2};
    private final IFarmable cocoa = new FarmableCocoa();

    public FarmLogicCocoa(IFarmType properties, boolean isManual) {
        super(properties, isManual);
    }

    @Override
    public boolean cultivate(Level level, IFarmHousing farmHousing, BlockPos pos, Direction direction, int extent) {
        if (this.maintainSoil(level, farmHousing, pos, direction, extent)) {
            return true;
        }
        BlockPos position = farmHousing.getValidPosition(direction, pos, extent, pos.m_7494_());
        boolean result = this.tryPlantingCocoa(level, farmHousing, position, direction);
        farmHousing.increaseExtent(direction, pos, extent);
        return result;
    }

    protected boolean maintainSoil(Level world, IFarmHousing farmHousing, BlockPos pos, Direction direction, int extent) {
        if (!farmHousing.canPlantSoil(this.isManual)) {
            return false;
        }
        BlockPos cornerPos = farmHousing.getFarmCorner(direction);
        int distance = this.getDistanceValue(direction.m_122427_(), cornerPos, pos) - 1;
        int layoutExtent = LAYOUT_POSITIONS[distance % LAYOUT_POSITIONS.length];
        block0: for (Soil soil : this.getSoils()) {
            BlockPos position;
            NonNullList resources = NonNullList.m_122779_();
            resources.add((Object)soil.resource());
            for (int i = 0; i < extent && world.m_46805_(position = this.translateWithOffset(pos, direction, i)); ++i) {
                if (!this.isValidPosition(direction, position, pos, layoutExtent) || !farmHousing.getFarmInventory().hasResources((List<ItemStack>)resources)) continue;
                BlockPos platformPosition = position.m_7495_();
                if (!farmHousing.isValidPlatform(world, platformPosition)) continue block0;
                for (int z = 0; z < 3; ++z) {
                    BlockPos location = position.m_6630_(z);
                    BlockState state = world.m_8055_(location);
                    if (z == 0 && !world.m_46859_(location) || z > 0 && this.isAcceptedSoil(state) || !BlockUtil.isBreakableBlock(state, world, pos)) continue;
                    if (!BlockUtil.isReplaceableBlock(state, world, location)) {
                        BlockUtil.getBlockDrops((LevelAccessor)world, location).forEach(farmHousing::addPendingProduct);
                        world.m_46597_(location, Blocks.f_50016_.m_49966_());
                        return FarmLogicCocoa.trySetSoil(world, farmHousing, location, soil.resource(), soil.soilState());
                    }
                    if (this.isManual) continue;
                    return FarmLogicCocoa.trySetSoil(world, farmHousing, location, soil.resource(), soil.soilState());
                }
            }
        }
        return false;
    }

    protected int getDistanceValue(Direction facing, BlockPos posA, BlockPos posB) {
        BlockPos delta = posA.m_121996_((Vec3i)posB);
        int value = switch (facing.m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> delta.m_123341_();
            case Direction.Axis.Y -> delta.m_123342_();
            case Direction.Axis.Z -> delta.m_123343_();
        };
        return Math.abs(value);
    }

    protected boolean isValidPosition(Direction direction, BlockPos pos, BlockPos logicPos, int layoutExtent) {
        int distance = this.getDistanceValue(direction, pos, logicPos);
        return distance % LAYOUT_POSITIONS.length == layoutExtent;
    }

    protected static boolean trySetSoil(Level world, IFarmHousing farmHousing, BlockPos position, ItemStack resource, BlockState ground) {
        NonNullList resources = NonNullList.m_122779_();
        resources.add((Object)resource);
        if (!farmHousing.getFarmInventory().hasResources((List<ItemStack>)resources)) {
            return false;
        }
        if (!BlockUtil.setBlockWithPlaceSound(world, position, ground)) {
            return false;
        }
        farmHousing.getFarmInventory().removeResources((List<ItemStack>)resources);
        return true;
    }

    @Override
    public Collection<ICrop> harvest(Level level, IFarmHousing housing, Direction direction, int extent, BlockPos pos) {
        BlockPos position = housing.getValidPosition(direction, pos, extent, pos.m_7494_());
        Collection<ICrop> crops = this.getHarvestBlocks(level, position);
        housing.increaseExtent(direction, pos, extent);
        return crops;
    }

    private boolean tryPlantingCocoa(Level world, IFarmHousing farmHousing, BlockPos position, Direction farmDirection) {
        BlockPos.MutableBlockPos current = new BlockPos.MutableBlockPos();
        BlockState blockState = world.m_8055_((BlockPos)current.m_122190_((Vec3i)position));
        while (FarmLogicCocoa.isJungleTreeTrunk(blockState)) {
            for (Direction direction : HorizontalDirection.VALUES) {
                BlockPos candidate = new BlockPos(current.m_123341_() + direction.m_122429_(), current.m_123342_(), current.m_123343_() + direction.m_122431_());
                if (!world.m_46805_(candidate) || !world.m_46859_(candidate)) continue;
                return farmHousing.plantGermling(this.cocoa, world, candidate, farmDirection);
            }
            current.m_122173_(Direction.UP);
            if (current.m_123342_() - position.m_123342_() > 1) break;
            blockState = world.m_8055_((BlockPos)current);
        }
        return false;
    }

    private static boolean isJungleTreeTrunk(BlockState state) {
        return state.m_204336_(BlockTags.f_13111_);
    }

    private Collection<ICrop> getHarvestBlocks(Level world, BlockPos position) {
        HashSet<BlockPos> seen = new HashSet<BlockPos>();
        ArrayDeque<ICrop> crops = new ArrayDeque<ICrop>();
        BlockState blockState = world.m_8055_(position);
        ICrop crop = null;
        if (!blockState.m_204336_(BlockTags.f_13106_) && (crop = this.cocoa.getCropAt(world, position, blockState)) == null) {
            return crops;
        }
        if (crop != null) {
            crops.add(crop);
        }
        List<BlockPos> candidates = this.processHarvestBlock(world, crops, seen, position, position);
        ArrayList<BlockPos> temp = new ArrayList<BlockPos>();
        while (!candidates.isEmpty() && crops.size() < 20) {
            for (BlockPos candidate : candidates) {
                temp.addAll(this.processHarvestBlock(world, crops, seen, position, candidate));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private List<BlockPos> processHarvestBlock(Level world, ArrayDeque<ICrop> crops, Set<BlockPos> seen, BlockPos start, BlockPos position) {
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (int i = -1; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    BlockPos candidate = position.m_7918_(i, j, k);
                    if (candidate.equals((Object)position) || Math.abs(candidate.m_123341_() - start.m_123341_()) > 5 || Math.abs(candidate.m_123343_() - start.m_123343_()) > 5 || seen.contains(candidate) || !world.m_46805_(candidate)) continue;
                    BlockState blockState = world.m_8055_(candidate);
                    ICrop crop = this.cocoa.getCropAt(world, candidate, blockState);
                    if (crop != null) {
                        crops.addFirst(crop);
                        candidates.add(candidate);
                        seen.add(candidate);
                        continue;
                    }
                    if (!blockState.m_204336_(BlockTags.f_13106_)) continue;
                    candidates.add(candidate);
                    seen.add(candidate);
                }
            }
        }
        return candidates;
    }
}

