/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.farmables;

import com.google.common.collect.ImmutableSet;
import forestry.api.arboriculture.genetics.IFruit;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.arboriculture.genetics.ITreeSpeciesType;
import forestry.api.core.IProduct;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.arboriculture.features.ArboricultureBlocks;
import forestry.core.utils.SpeciesUtil;
import forestry.farming.logic.crops.CropDestroy;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class FarmableGE
implements IFarmable {
    private final ImmutableSet<Item> windfall;

    public FarmableGE() {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (IFruit fruit : TreeChromosomes.FRUIT.values()) {
            for (IProduct product : fruit.getProducts()) {
                builder.add((Object)product.item());
            }
        }
        this.windfall = builder.build();
    }

    @Override
    public boolean isSaplingAt(Level level, BlockPos pos, BlockState state) {
        return ArboricultureBlocks.SAPLING_GE.blockEqual(state);
    }

    @Override
    @Nullable
    public ICrop getCropAt(Level level, BlockPos pos, BlockState state) {
        if (!state.m_204336_(BlockTags.f_13106_)) {
            return null;
        }
        return new CropDestroy(level, state, pos, null);
    }

    @Override
    public boolean plantSaplingAt(Player player, ItemStack germling, Level level, BlockPos pos) {
        ITreeSpeciesType treeRoot = (ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get();
        return IIndividualHandlerItem.filter(germling, individual -> {
            ITree tree;
            return individual instanceof ITree && treeRoot.plantSapling(level, tree = (ITree)individual, player.m_36316_(), pos);
        });
    }

    @Override
    public boolean isGermling(ItemStack stack) {
        return ((ITreeSpeciesType)SpeciesUtil.TREE_TYPE.get()).isMember(stack);
    }

    @Override
    public boolean isWindfall(ItemStack stack) {
        return this.windfall.contains((Object)stack.m_41720_());
    }
}

