/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.tiles;

import forestry.api.genetics.IGenome;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.ButterflyChromosomes;
import forestry.api.lepidopterology.genetics.IButterfly;
import forestry.api.lepidopterology.genetics.IButterflySpecies;
import forestry.api.lepidopterology.genetics.IButterflySpeciesType;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.SpeciesUtil;
import forestry.lepidopterology.blocks.BlockCocoon;
import forestry.lepidopterology.features.LepidopterologyTiles;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TileCocoon
extends BlockEntity {
    private int maturationTime;
    private IButterfly caterpillar = (IButterfly)((IButterflySpecies)((IButterflySpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get()).getDefaultSpecies()).createIndividual();
    private boolean isSolid;

    public TileCocoon(BlockPos pos, BlockState state, boolean isSolid) {
        super(isSolid ? LepidopterologyTiles.SOLID_COCOON.tileType() : LepidopterologyTiles.COCOON.tileType(), pos, state);
        this.isSolid = isSolid;
    }

    public void m_142466_(CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        if (compoundNBT.m_128441_("Caterpillar")) {
            this.caterpillar = (IButterfly)SpeciesUtil.deserializeIndividual((ISpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get(), (Tag)compoundNBT.m_128469_("Caterpillar"));
        }
        this.maturationTime = compoundNBT.m_128451_("CATMAT");
        this.isSolid = compoundNBT.m_128471_("isSolid");
    }

    public void m_183515_(CompoundTag compoundNBT) {
        super.m_183515_(compoundNBT);
        Tag tag = SpeciesUtil.serializeIndividual(this.caterpillar);
        if (tag != null) {
            compoundNBT.m_128365_("Caterpillar", tag);
        }
        compoundNBT.m_128405_("CATMAT", this.maturationTime);
        compoundNBT.m_128379_("isSolid", this.isSolid);
    }

    public void onBlockTick() {
        ++this.maturationTime;
        IGenome caterpillarGenome = this.caterpillar.getGenome();
        int caterpillarMatureTime = Math.round((float)caterpillarGenome.getActiveValue(ButterflyChromosomes.LIFESPAN) / (float)(caterpillarGenome.getActiveValue(ButterflyChromosomes.FERTILITY) * 2));
        if (this.maturationTime >= caterpillarMatureTime) {
            int age = (Integer)this.m_58900_().m_61143_((Property)BlockCocoon.AGE);
            if (age < 2) {
                this.maturationTime = 0;
                BlockState blockState = (BlockState)this.m_58900_().m_61124_((Property)BlockCocoon.AGE, (Comparable)Integer.valueOf(age + 1));
                this.f_58857_.m_7731_(this.f_58858_, blockState, 3);
            } else if (this.caterpillar.canTakeFlight(this.f_58857_, this.m_58899_().m_123341_(), this.m_58899_().m_123342_(), this.m_58899_().m_123343_())) {
                List<ItemStack> cocoonDrops = this.caterpillar.getCocoonDrop(this.isSolid, this.caterpillar.getGenome().getActiveValue(ButterflyChromosomes.COCOON));
                for (ItemStack drop : cocoonDrops) {
                    ItemStackUtil.dropItemStackAsEntity(drop, this.f_58857_, this.f_58858_);
                }
                this.f_58857_.m_46597_(this.m_58899_(), Blocks.f_50016_.m_49966_());
                TileCocoon.attemptButterflySpawn(this.f_58857_, this.caterpillar, this.m_58899_());
            }
        }
    }

    private static void attemptButterflySpawn(Level world, IButterfly butterfly, BlockPos pos) {
        ((IButterflySpeciesType)SpeciesUtil.BUTTERFLY_TYPE.get()).spawnButterflyInWorld(world, butterfly.copy(), pos.m_123341_(), (float)pos.m_123342_() + 0.1f, pos.m_123343_());
    }

    public IButterfly getCaterpillar() {
        return this.caterpillar;
    }

    public void setCaterpillar(IButterfly caterpillar) {
        this.caterpillar = caterpillar;
    }

    public List<ItemStack> getCocoonDrops() {
        return this.caterpillar.getCocoonDrop(this.isSolid, this.caterpillar.getGenome().getActiveValue(ButterflyChromosomes.COCOON));
    }
}

