/*
 * Decompiled with CFR 0.152.
 */
package forestry.mail;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import forestry.api.mail.IMailAddress;
import forestry.api.mail.IPostalCarrier;
import forestry.core.utils.PlayerUtil;
import forestry.mail.carriers.PostalCarriers;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class MailAddress
implements IMailAddress {
    private static final GameProfile invalidGameProfile = new GameProfile(new UUID(0L, 0L), "");
    public static final MailAddress INVALID = new MailAddress(invalidGameProfile);
    private final IPostalCarrier carrier;
    private final GameProfile gameProfile;

    public MailAddress(GameProfile gameProfile) {
        this.carrier = (IPostalCarrier)PostalCarriers.PLAYER.get();
        this.gameProfile = gameProfile;
    }

    public MailAddress(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name must not be null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)name), (Object)"name must not be blank");
        this.carrier = (IPostalCarrier)PostalCarriers.TRADER.get();
        this.gameProfile = new GameProfile(null, name);
    }

    public MailAddress(CompoundTag nbt) {
        CompoundTag profileTag;
        IPostalCarrier carrier = null;
        GameProfile gameProfile = invalidGameProfile;
        if (nbt.m_128441_("carrier")) {
            carrier = (IPostalCarrier)PostalCarriers.REGISTRY.get().getValue(ResourceLocation.m_135820_((String)nbt.m_128461_("carrier")));
        }
        if (carrier == null) {
            carrier = (IPostalCarrier)PostalCarriers.PLAYER.get();
            gameProfile = invalidGameProfile;
        } else if (nbt.m_128441_("profile") && (gameProfile = NbtUtils.m_129228_((CompoundTag)(profileTag = nbt.m_128469_("profile")))) == null) {
            gameProfile = invalidGameProfile;
        }
        this.carrier = carrier;
        this.gameProfile = gameProfile;
    }

    @Override
    public IPostalCarrier getCarrier() {
        return this.carrier;
    }

    @Override
    public String getName() {
        return this.gameProfile.getName();
    }

    @Override
    public boolean isValid() {
        return this.gameProfile.getName() != null && !PlayerUtil.isSameGameProfile(this.gameProfile, invalidGameProfile);
    }

    @Override
    public GameProfile getPlayerProfile() {
        if (!this.carrier.equals(PostalCarriers.PLAYER.get())) {
            return invalidGameProfile;
        }
        return this.gameProfile;
    }

    public int hashCode() {
        return this.gameProfile.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MailAddress)) {
            return false;
        }
        MailAddress address = (MailAddress)o;
        return PlayerUtil.isSameGameProfile(address.gameProfile, this.gameProfile);
    }

    public String toString() {
        String name = this.getName().toLowerCase(Locale.ENGLISH);
        if (this.getCarrier().equals(PostalCarriers.PLAYER.get())) {
            return this.carrier + "-" + name + "-" + this.gameProfile.getId();
        }
        return this.carrier + "-" + name;
    }

    @Override
    public CompoundTag write(CompoundTag compoundNBT) {
        compoundNBT.m_128359_("carrier", PostalCarriers.REGISTRY.get().getKey((Object)this.carrier).toString());
        if (this.gameProfile != invalidGameProfile) {
            CompoundTag profileNbt = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)profileNbt, (GameProfile)this.gameProfile);
            compoundNBT.m_128365_("profile", (Tag)profileNbt);
        }
        return compoundNBT;
    }
}

