/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting.network.packets;

import forestry.api.ForestryCapabilities;
import forestry.api.IForestryApi;
import forestry.api.genetics.filter.IFilterLogic;
import forestry.api.genetics.filter.IFilterRuleType;
import forestry.api.modules.IForestryPacketServer;
import forestry.core.network.PacketIdServer;
import forestry.core.tiles.TileUtil;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record PacketFilterChangeRule(BlockPos pos, Direction facing, IFilterRuleType rule) implements IForestryPacketServer
{
    @Override
    public ResourceLocation id() {
        return PacketIdServer.FILTER_CHANGE_RULE;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeShort(this.facing.m_122411_());
        buffer.writeShort(IForestryApi.INSTANCE.getFilterManager().getId(this.rule));
    }

    public static PacketFilterChangeRule decode(FriendlyByteBuf buffer) {
        return new PacketFilterChangeRule(buffer.m_130135_(), Direction.f_122346_[buffer.readShort()], Objects.requireNonNull(IForestryApi.INSTANCE.getFilterManager().getRule(buffer.readShort())));
    }

    public static void handle(PacketFilterChangeRule msg, ServerPlayer player) {
        TileUtil.getInterface(player.m_9236_(), msg.pos(), ForestryCapabilities.FILTER_LOGIC, null).ifPresent(logic -> {
            if (logic.setRule(msg.facing(), msg.rule())) {
                logic.getNetworkHandler().sendToPlayers((IFilterLogic)logic, player.m_284548_(), (Player)player);
            }
        });
    }
}

