/*
 * Decompiled with CFR 0.152.
 */
package forestry.worktable.recipes;

import forestry.api.core.INbtReadable;
import forestry.api.core.INbtWritable;
import forestry.core.network.IStreamable;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.RecipeUtils;
import forestry.worktable.inventory.WorktableCraftingContainer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class MemorizedRecipe
implements INbtWritable,
INbtReadable,
IStreamable {
    private WorktableCraftingContainer craftMatrix = new WorktableCraftingContainer();
    private List<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
    private final List<ResourceLocation> recipeIds = new ArrayList<ResourceLocation>();
    private int selectedRecipe;
    private long lastUsed;
    private boolean locked;

    public MemorizedRecipe(FriendlyByteBuf buffer) {
        this.readData(buffer);
    }

    public MemorizedRecipe(CompoundTag nbt) {
        this.read(nbt);
    }

    public MemorizedRecipe(CraftingContainer craftMatrix, List<CraftingRecipe> recipes) {
        InventoryUtil.deepCopyInventoryContents((Container)craftMatrix, (Container)this.craftMatrix);
        this.recipes = recipes;
        for (CraftingRecipe recipe : recipes) {
            this.recipeIds.add(recipe.m_6423_());
        }
    }

    public WorktableCraftingContainer getCraftMatrix() {
        return this.craftMatrix;
    }

    public void setCraftMatrix(WorktableCraftingContainer usedMatrix) {
        this.craftMatrix = usedMatrix;
    }

    public void incrementRecipe() {
        ++this.selectedRecipe;
        if (this.selectedRecipe >= this.recipes.size()) {
            this.selectedRecipe = 0;
        }
    }

    public void decrementRecipe() {
        --this.selectedRecipe;
        if (this.selectedRecipe < 0) {
            this.selectedRecipe = this.recipes.size() - 1;
        }
    }

    public boolean hasRecipeConflict() {
        return this.recipes.size() > 1;
    }

    public void removeRecipeConflicts() {
        CraftingRecipe recipe = this.getSelectedRecipe();
        this.recipes.clear();
        this.recipes.add(recipe);
        this.selectedRecipe = 0;
    }

    public ItemStack getOutputIcon(Level level) {
        ItemStack recipeOutput;
        CraftingRecipe selectedRecipe = this.getSelectedRecipe();
        if (selectedRecipe != null && !(recipeOutput = selectedRecipe.m_5874_((Container)this.craftMatrix, level.m_9598_())).m_41619_()) {
            return recipeOutput;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getCraftingResult(CraftingContainer inventory, Level level) {
        ItemStack recipeOutput;
        CraftingRecipe selectedRecipe = this.getSelectedRecipe();
        if (selectedRecipe != null && selectedRecipe.m_5818_((Container)inventory, level) && !(recipeOutput = selectedRecipe.m_5874_((Container)inventory, level.m_9598_())).m_41619_()) {
            return recipeOutput;
        }
        return ItemStack.f_41583_;
    }

    public boolean hasRecipes() {
        return !this.recipes.isEmpty() || !this.recipeIds.isEmpty();
    }

    public boolean hasSelectedRecipe() {
        return this.hasRecipes() && this.selectedRecipe >= 0 && this.recipeIds.size() > this.selectedRecipe && this.recipeIds.get(this.selectedRecipe) != null;
    }

    public List<CraftingRecipe> getRecipes() {
        if (this.recipes.isEmpty() && !this.recipeIds.isEmpty()) {
            for (ResourceLocation key : this.recipeIds) {
                Recipe recipe = RecipeUtils.getRecipe(RecipeType.f_44107_, key);
                if (!(recipe instanceof CraftingRecipe)) continue;
                this.recipes.add((CraftingRecipe)recipe);
            }
            if (this.selectedRecipe > this.recipes.size()) {
                this.selectedRecipe = 0;
            }
        }
        return this.recipes;
    }

    @Nullable
    public CraftingRecipe getSelectedRecipe() {
        List<CraftingRecipe> recipes = this.getRecipes();
        if (recipes.isEmpty()) {
            return null;
        }
        return recipes.get(this.selectedRecipe);
    }

    public boolean hasRecipe(@Nullable CraftingRecipe recipe) {
        return this.getRecipes().contains(recipe);
    }

    public void updateLastUse(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    public long getLastUsed() {
        return this.lastUsed;
    }

    public void toggleLock() {
        this.locked = !this.locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public final void read(CompoundTag compoundNBT) {
        InventoryUtil.readFromNBT((Container)this.craftMatrix, "inventory", compoundNBT);
        this.lastUsed = compoundNBT.m_128454_("LastUsed");
        this.locked = compoundNBT.m_128471_("Locked");
        if (compoundNBT.m_128441_("SelectedRecipe")) {
            this.selectedRecipe = compoundNBT.m_128451_("SelectedRecipe");
        }
        this.recipes.clear();
        this.recipeIds.clear();
        ListTag recipesNbt = compoundNBT.m_128437_("Recipes", 8);
        for (int i = 0; i < recipesNbt.size(); ++i) {
            String recipeKey = recipesNbt.m_128778_(i);
            this.recipeIds.add(new ResourceLocation(recipeKey));
        }
        if (this.selectedRecipe > this.recipeIds.size()) {
            this.selectedRecipe = 0;
        }
    }

    @Override
    public CompoundTag write(CompoundTag compoundNBT) {
        InventoryUtil.writeToNBT((Container)this.craftMatrix, "inventory", compoundNBT);
        compoundNBT.m_128356_("LastUsed", this.lastUsed);
        compoundNBT.m_128379_("Locked", this.locked);
        compoundNBT.m_128405_("SelectedRecipe", this.selectedRecipe);
        ListTag recipesNbt = new ListTag();
        for (ResourceLocation recipeName : this.recipeIds) {
            recipesNbt.add((Object)StringTag.m_129297_((String)recipeName.toString()));
        }
        compoundNBT.m_128365_("Recipes", (Tag)recipesNbt);
        return compoundNBT;
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        NetworkUtil.writeInventory(data, (Container)this.craftMatrix);
        data.writeBoolean(this.locked);
        data.m_130130_(this.selectedRecipe);
        data.m_130130_(this.recipeIds.size());
        for (ResourceLocation recipeName : this.recipeIds) {
            data.m_130085_(recipeName);
        }
    }

    @Override
    public void readData(FriendlyByteBuf data) {
        NetworkUtil.readInventory(data, (Container)this.craftMatrix);
        this.locked = data.readBoolean();
        this.selectedRecipe = data.m_130242_();
        this.recipes.clear();
        this.recipeIds.clear();
        int recipeCount = data.m_130242_();
        for (int i = 0; i < recipeCount; ++i) {
            ResourceLocation recipeId = data.m_130281_();
            this.recipeIds.add(recipeId);
        }
    }
}

