/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.blockentity;

import com.google.common.collect.ImmutableList;
import forestry.api.IForestryApi;
import forestry.api.core.IError;
import forestry.api.core.IErrorLogic;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.AllelePair;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.alleles.IKaryotype;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.api.plugin.IGenomeBuilder;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.StandardTank;
import forestry.core.inventory.IInventoryAdapter;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.gendustry.blockentity.AdvancedMutatronBlockEntity;
import thedarkcolour.gendustry.blockentity.MutatronBlockEntity;
import thedarkcolour.gendustry.blockentity.MutatronInventory;
import thedarkcolour.gendustry.blockentity.PoweredTankBlockEntity;
import thedarkcolour.gendustry.compat.forestry.GendustryError;
import thedarkcolour.gendustry.menu.AdvancedMutatronMenu;
import thedarkcolour.gendustry.menu.MutatronMenu;
import thedarkcolour.gendustry.registry.GBlockEntities;
import thedarkcolour.gendustry.registry.GFluids;

public abstract class AbstractMutatronBlockEntity
extends PoweredTankBlockEntity {
    private static final int ENERGY_PER_WORK_CYCLE = 100000;
    private static final int TICKS_PER_WORK_CYCLE = 40;
    public static final String HINTS_KEY = "gendustry.mutatron";
    private final FilteredTank mutagenTank;
    protected final MutatronInventory inventory;
    public final boolean isAdvanced;
    @Nullable
    private IMutation<?> currentMutation;
    protected ItemStack currentPrimary = ItemStack.f_41583_;
    protected ItemStack currentSecondary = ItemStack.f_41583_;
    @Nullable
    private UUID lastPlayer;

    public AbstractMutatronBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 10000, 1000000);
        this.mutagenTank = new FilteredTank(10000).setFilters(Set.of(GFluids.MUTAGEN.fluid()));
        this.tankManager.add((StandardTank)this.mutagenTank);
        this.inventory = new MutatronInventory(this);
        this.isAdvanced = type == GBlockEntities.ADVANCED_MUTATRON.tileType();
        this.setInternalInventory((IInventoryAdapter)this.inventory);
        this.setTicksPerWorkCycle(40);
        this.setEnergyPerWorkCycle(100000);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        super.serverTick(level, pos, state);
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers((IFluidHandler)this.tankManager, (Container)this, (int)3);
        }
    }

    public boolean hasWork() {
        IErrorLogic errors = this.getErrorLogic();
        boolean noMutagen = this.mutagenTank.getFluid().getAmount() < 1000;
        errors.setCondition(noMutagen, (IError)GendustryError.NO_MUTAGEN);
        boolean noLabware = this.inventory.m_8020_(2).m_41619_();
        errors.setCondition(noLabware, (IError)GendustryError.NO_LABWARE);
        if (this.hasMutation() && (this.inventory.m_8020_(0) != this.currentPrimary || this.inventory.m_8020_(1) != this.currentSecondary || this.currentSecondary.m_41619_() || this.currentSecondary.m_41619_())) {
            this.onMutationsUpdated(List.of(), ItemStack.f_41583_, ItemStack.f_41583_);
        }
        if (!this.hasMutation()) {
            ItemStack primaryStack = this.inventory.m_8020_(0);
            ItemStack secondaryStack = this.inventory.m_8020_(1);
            IIndividual primary = IIndividualHandlerItem.getIndividual((ItemStack)primaryStack);
            IIndividual secondary = IIndividualHandlerItem.getIndividual((ItemStack)secondaryStack);
            boolean noMates = primary == null || secondary == null;
            errors.setCondition(noMates, (IError)GendustryError.NO_MATES);
            if (noMates) {
                return false;
            }
            boolean incompatible = primary.getType() != secondary.getType();
            errors.setCondition(incompatible, (IError)GendustryError.INCOMPATIBLE_SPECIES);
            if (incompatible) {
                return false;
            }
            List mutations = IForestryApi.INSTANCE.getGeneticManager().getMutations(primary.getType()).getCombinations(primary.getSpecies(), secondary.getSpecies());
            boolean noMutations = mutations.isEmpty();
            errors.setCondition(noMutations, (IError)GendustryError.NO_MUTATIONS);
            if (noMutations) {
                return false;
            }
            this.onMutationsUpdated(mutations, primaryStack, secondaryStack);
        }
        return !noMutagen && !noLabware;
    }

    protected boolean hasMutation() {
        return this.currentMutation != null;
    }

    protected abstract void onMutationsUpdated(List<IMutation<ISpecies<?>>> var1, ItemStack var2, ItemStack var3);

    protected boolean workCycle() {
        if (!this.inventory.m_8020_(4).m_41619_()) {
            return false;
        }
        ItemStack primary = this.inventory.m_7407_(0, 1);
        this.inventory.m_7407_(1, 1);
        this.inventory.m_7407_(2, 1);
        this.mutagenTank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
        IIndividualHandlerItem.ifPresent((ItemStack)primary, individual -> {
            ISpeciesType speciesType = individual.getType();
            IGenome genome = AbstractMutatronBlockEntity.createMutatedGenome(this.currentMutation);
            IIndividual newIndividual = individual.copyWithGenome(genome);
            newIndividual.setMate(genome);
            ItemStack result = newIndividual.createStack(speciesType.getTypeForMutation(2));
            this.inventory.m_6836_(4, result);
            if (this.lastPlayer != null) {
                Player player = this.f_58857_.m_46003_(this.lastPlayer);
                if (player == null) {
                    this.lastPlayer = null;
                } else {
                    IBreedingTracker tracker = speciesType.getBreedingTracker((LevelAccessor)this.f_58857_, player.m_36316_());
                    tracker.registerMutation(this.currentMutation);
                }
            }
        });
        this.setCurrentMutation(null, ItemStack.f_41583_, ItemStack.f_41583_);
        return true;
    }

    public static IGenome createMutatedGenome(IMutation<?> mutation) {
        IKaryotype karyotype = mutation.getType().getKaryotype();
        IGenomeBuilder builder = karyotype.createGenomeBuilder();
        ImmutableList allelePairs = mutation.getResultAlleles();
        ImmutableList chromosomes = karyotype.getChromosomes();
        for (int i = 0; i < chromosomes.size(); ++i) {
            IChromosome chromosome = (IChromosome)chromosomes.get(i);
            AllelePair pair = (AllelePair)allelePairs.get(i);
            builder.setUnchecked(chromosome, pair);
        }
        return builder.build();
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
        this.lastPlayer = player.m_20148_();
        return this.isAdvanced ? new AdvancedMutatronMenu(windowId, playerInv, (AdvancedMutatronBlockEntity)this) : new MutatronMenu(windowId, playerInv, (MutatronBlockEntity)this);
    }

    public void setCurrentMutation(@Nullable IMutation<?> mutation, ItemStack primary, ItemStack secondary) {
        this.currentMutation = mutation;
        this.currentPrimary = primary;
        this.currentSecondary = secondary;
    }

    @Nullable
    public IMutation<?> getCurrentMutation() {
        return this.currentMutation;
    }
}

