/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.blockentity;

import forestry.api.core.ForestryError;
import forestry.api.core.IError;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.gendustry.blockentity.ProducerBlockEntity;
import thedarkcolour.gendustry.recipe.DnaRecipe;
import thedarkcolour.gendustry.recipe.cache.DnaRecipeCache;
import thedarkcolour.gendustry.registry.GBlockEntities;
import thedarkcolour.gendustry.registry.GFluids;

public class DnaExtractorBlockEntity
extends ProducerBlockEntity<DnaExtractorBlockEntity, DnaRecipe> {
    private static final int ENERGY_PER_WORK_CYCLE = 80000;
    private static final int TICKS_PER_WORK_CYCLE = 50;
    public static final String HINTS_KEY = "gendustry.dna_extractor";

    public DnaExtractorBlockEntity(BlockPos pos, BlockState state) {
        super(GBlockEntities.DNA_EXTRACTOR, GFluids.LIQUID_DNA, true, pos, state);
    }

    @Override
    public boolean isValidInput(ItemStack input) {
        return IIndividualHandlerItem.isIndividual((ItemStack)input);
    }

    @Override
    @Nullable
    public DnaRecipe getRecipe(ItemStack input) {
        IIndividualHandlerItem handler = IIndividualHandlerItem.get((ItemStack)input);
        return handler == null ? null : DnaRecipeCache.INSTANCE.getRecipe(handler.getStage());
    }

    @Override
    public void startWorking() {
        this.setTicksPerWorkCycle(50);
        this.setEnergyPerWorkCycle(80000);
    }

    @Override
    public IError getNoInputError() {
        return ForestryError.NO_SPECIMEN;
    }

    @Override
    public String getHintsKey() {
        return HINTS_KEY;
    }
}

