/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.blockentity;

import forestry.api.core.ForestryError;
import forestry.api.core.IError;
import forestry.api.core.IErrorLogic;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IChromosome;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.tiles.TilePowered;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import thedarkcolour.gendustry.blockentity.IHintTile;
import thedarkcolour.gendustry.blockentity.ImprinterInventory;
import thedarkcolour.gendustry.compat.forestry.GendustryError;
import thedarkcolour.gendustry.item.GeneticTemplateItem;
import thedarkcolour.gendustry.menu.ThreeInputMenu;
import thedarkcolour.gendustry.registry.GBlockEntities;

public class ImprinterBlockEntity
extends TilePowered
implements IHintTile {
    public static final String HINTS_KEY = "gendustry.imprinter";
    private final ImprinterInventory inventory = new ImprinterInventory(this);

    public ImprinterBlockEntity(BlockPos pos, BlockState state) {
        super(GBlockEntities.IMPRINTER.tileType(), pos, state, 10000, 1000000);
        this.setInternalInventory((IInventoryAdapter)this.inventory);
        this.setTicksPerWorkCycle(80);
        this.setEnergyPerWorkCycle(100000);
    }

    public boolean hasWork() {
        IErrorLogic errors = this.getErrorLogic();
        boolean noSpecimen = errors.setCondition(this.inventory.m_8020_(0).m_41619_(), (IError)ForestryError.NO_SPECIMEN);
        boolean noTemplate = errors.setCondition(this.inventory.m_8020_(1).m_41619_(), (IError)GendustryError.NO_TEMPLATE);
        boolean noLabware = errors.setCondition(this.inventory.m_8020_(2).m_41619_(), (IError)GendustryError.NO_LABWARE);
        return !noTemplate && !noLabware && !noSpecimen;
    }

    protected boolean workCycle() {
        if (!this.inventory.m_8020_(3).m_41619_()) {
            return false;
        }
        ItemStack organism = this.inventory.m_7407_(0, 1);
        this.inventory.m_7407_(2, 1);
        return IIndividualHandlerItem.filter((ItemStack)organism, (individual, stage) -> {
            ItemStack template = this.inventory.m_8020_(1);
            Map<IChromosome<?>, IAllele> alleles = GeneticTemplateItem.getAlleles(template);
            IGenome newGenome = individual.getGenome().copyWith(alleles);
            IIndividual newIndividual = individual.copyWithGenome(newGenome);
            if (individual.getMate() != null) {
                newIndividual.setMate(newGenome);
            }
            this.inventory.m_6836_(3, newIndividual.createStack(stage));
            return true;
        });
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
        return ThreeInputMenu.imprinter(windowId, playerInv, this);
    }

    @Override
    public String getHintsKey() {
        return HINTS_KEY;
    }
}

