/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.blockentity;

import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.genetics.IBeeSpecies;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutation;
import forestry.core.inventory.IInventoryAdapter;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.gendustry.item.EliteGendustryUpgradeType;
import thedarkcolour.gendustry.item.GendustryUpgradeItem;
import thedarkcolour.gendustry.item.GendustryUpgradeType;
import thedarkcolour.gendustry.item.IGendustryUpgradeType;

class IndustrialApiaryBeeModifier
implements IBeeModifier {
    float territory;
    float mutation;
    float lifespan;
    float productivity;
    float pollination;
    int throttle;
    int fertility;
    int temperature;
    int humidity;
    boolean automated;
    boolean stabilized;
    boolean weatherproof;
    boolean lighting;
    boolean sky;
    boolean nether;
    boolean scrubber;
    boolean sieve;

    IndustrialApiaryBeeModifier() {
        this.reset();
    }

    private void reset() {
        this.territory = 1.0f;
        this.mutation = 1.0f;
        this.lifespan = 1.0f;
        this.productivity = 1.0f;
        this.pollination = 1.0f;
        this.throttle = 0;
        this.fertility = 0;
        this.temperature = 0;
        this.humidity = 0;
        this.automated = false;
        this.stabilized = false;
        this.weatherproof = false;
        this.lighting = false;
        this.sky = false;
        this.nether = false;
        this.scrubber = false;
        this.sieve = false;
    }

    public int recalculate(IInventoryAdapter inventory) {
        this.reset();
        int energyCost = 0;
        block26: for (int i = 0; i < 4; ++i) {
            ItemStack stack = inventory.m_8020_(2 + i);
            Item item = stack.m_41720_();
            int count = stack.m_41613_();
            if (!(item instanceof GendustryUpgradeItem)) continue;
            GendustryUpgradeItem upgrade = (GendustryUpgradeItem)item;
            IGendustryUpgradeType upgradeType = upgrade.getType();
            energyCost += upgradeType.energyCost() * count;
            if (upgradeType instanceof GendustryUpgradeType) {
                GendustryUpgradeType type = (GendustryUpgradeType)upgradeType;
                switch (type) {
                    case AUTOMATION: {
                        this.automated = true;
                        break;
                    }
                    case HEATER: {
                        this.temperature += count;
                        break;
                    }
                    case COOLER: {
                        this.temperature -= count;
                        break;
                    }
                    case HUMIDIFIER: {
                        this.humidity += count;
                        break;
                    }
                    case DRYER: {
                        this.humidity -= count;
                        break;
                    }
                    case POLLINATION: {
                        this.pollination += 0.25f * (float)count;
                        break;
                    }
                    case SCRUBBER: {
                        this.scrubber = true;
                        break;
                    }
                    case NETHER: {
                        this.nether = true;
                        break;
                    }
                    case LIFESPAN: {
                        this.lifespan += 2.0f * (float)count;
                        break;
                    }
                    case LIGHTING: {
                        this.lighting = true;
                        break;
                    }
                    case PRODUCTIVITY: {
                        this.productivity += 0.25f * (float)count;
                        break;
                    }
                    case WEATHERPROOF: {
                        this.weatherproof = true;
                        break;
                    }
                    case SIEVE: {
                        this.sieve = true;
                        break;
                    }
                    case SKY: {
                        this.sky = true;
                        break;
                    }
                    case STABILIZER: {
                        this.stabilized = true;
                        break;
                    }
                    case TERRITORY: {
                        this.territory += 0.25f * (float)count;
                    }
                }
                continue;
            }
            if (!(upgradeType instanceof EliteGendustryUpgradeType)) continue;
            EliteGendustryUpgradeType type = (EliteGendustryUpgradeType)upgradeType;
            switch (type) {
                case MUTATION: {
                    this.mutation += 0.25f;
                    continue block26;
                }
                case ACTIVITY_SIMULATOR: {
                    this.lighting = true;
                    this.sky = true;
                    this.weatherproof = true;
                    continue block26;
                }
                case PRODUCTIVITY: {
                    this.productivity += 0.25f * (float)count;
                    this.throttle += 15 * count;
                    continue block26;
                }
                case TERRITORY: {
                    this.territory += 0.25f * (float)count;
                    continue block26;
                }
                case YOUTH: {
                    this.mutation -= 0.2f * (float)count;
                    continue block26;
                }
                case FERTILITY: {
                    this.fertility += count;
                }
            }
        }
        return energyCost;
    }

    public Vec3i modifyTerritory(IGenome genome, Vec3i currentModifier) {
        return new Vec3i((int)((float)currentModifier.m_123341_() * this.territory), (int)((float)currentModifier.m_123342_() * this.territory), (int)((float)currentModifier.m_123343_() * this.territory));
    }

    public float modifyMutationChance(IGenome genome, IGenome mate, IMutation<IBeeSpecies> mutation, float currentChance) {
        return currentChance * this.mutation;
    }

    public float modifyAging(IGenome genome, @Nullable IGenome mate, float currentAging) {
        return currentAging * this.lifespan;
    }

    public float modifyProductionSpeed(IGenome genome, float currentSpeed) {
        return currentSpeed * this.productivity;
    }

    public float modifyPollination(IGenome genome, float currentPollination) {
        return this.scrubber ? 0.0f : currentPollination * this.pollination;
    }

    public float modifyGeneticDecay(IGenome genome, float currentDecay) {
        return this.stabilized ? 0.0f : currentDecay;
    }

    public boolean isSealed() {
        return this.weatherproof;
    }

    public boolean isAlwaysActive(IGenome genome) {
        return this.lighting;
    }

    public boolean isSunlightSimulated() {
        return this.sky;
    }

    public boolean isHellish() {
        return this.nether;
    }
}

