/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.blockentity;

import com.mojang.authlib.GameProfile;
import forestry.api.IForestryApi;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.genetics.BeeLifeStage;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.climate.ClimateState;
import forestry.api.climate.IClimateProvider;
import forestry.api.core.ForestryError;
import forestry.api.core.HumidityType;
import forestry.api.core.IError;
import forestry.api.core.IErrorLogic;
import forestry.api.core.TemperatureType;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.api.genetics.pollen.IPollen;
import forestry.apiculture.gui.IGuiBeeHousingDelegate;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.network.IStreamableGui;
import forestry.core.owner.IOwnedTile;
import forestry.core.owner.IOwnerHandler;
import forestry.core.owner.OwnerHandler;
import forestry.core.tiles.IPowerHandler;
import forestry.core.tiles.TileBase;
import forestry.core.utils.NetworkUtil;
import forestry.energy.EnergyHelper;
import forestry.energy.ForestryEnergyStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.gendustry.blockentity.IndustrialApiaryBeeModifier;
import thedarkcolour.gendustry.blockentity.IndustrialApiaryInventory;
import thedarkcolour.gendustry.menu.IndustrialApiaryMenu;
import thedarkcolour.gendustry.registry.GBlockEntities;

public class IndustrialApiaryBlockEntity
extends TileBase
implements IBeeHousing,
IOwnedTile,
IClimateProvider,
IGuiBeeHousingDelegate,
IStreamableGui,
IPowerHandler,
IBeeListener {
    public static final String HINTS_KEY = "gendustry.industrial_apiary";
    public static final int BASE_ENERGY = 200;
    private final ForestryEnergyStorage energyStorage = new ForestryEnergyStorage(100000, 1000000);
    private final LazyOptional<ForestryEnergyStorage> energyCap = LazyOptional.of(() -> this.energyStorage);
    private final IndustrialApiaryInventory inventory = new IndustrialApiaryInventory(this);
    private final OwnerHandler ownerHandler;
    private final IBeekeepingLogic beeLogic;
    protected IClimateProvider climate;
    private final IndustrialApiaryBeeModifier modifier;
    private int breedingProgressPercent;
    private int energyConsumption;
    protected boolean recycleQueen;

    public IndustrialApiaryBlockEntity(BlockPos pos, BlockState state) {
        super(GBlockEntities.INDUSTRIAL_APIARY.tileType(), pos, state);
        this.setInternalInventory((IInventoryAdapter)this.inventory);
        this.ownerHandler = new OwnerHandler();
        this.beeLogic = IForestryApi.INSTANCE.getHiveManager().createBeekeepingLogic((IBeeHousing)this);
        this.climate = IForestryApi.INSTANCE.getClimateManager().createDummyClimateProvider();
        this.modifier = new IndustrialApiaryBeeModifier();
        this.energyConsumption = 200;
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        this.climate = IForestryApi.INSTANCE.getClimateManager().createClimateProvider((LevelReader)level, this.f_58858_);
        this.refreshUpgrades();
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        IErrorLogic errors = this.getErrorLogic();
        boolean disabled = this.isRedstoneActivated();
        errors.setCondition(disabled, (IError)ForestryError.DISABLED_BY_REDSTONE);
        if (this.recycleQueen) {
            this.recycleQueen = false;
            this.recycleQueen();
        }
        if (!disabled && this.beeLogic.canWork()) {
            boolean hasEnergy = EnergyHelper.consumeEnergyToDoWork((ForestryEnergyStorage)this.energyStorage, (int)1, (int)this.energyConsumption);
            errors.setCondition(!hasEnergy, (IError)ForestryError.NO_POWER);
            if (hasEnergy) {
                this.beeLogic.doWork();
            }
        }
        if ((level.m_46467_() & 0x3FL) == 0L) {
            this.refreshClimate();
        }
    }

    private void recycleQueen() {
        for (int i = 0; i < 9; ++i) {
            int slotIndex = 6 + i;
            ItemStack stack = this.inventory.m_8020_(slotIndex);
            IIndividualHandlerItem.ifPresent((ItemStack)stack, (bee, stage) -> {
                if (stage == BeeLifeStage.PRINCESS) {
                    this.inventory.m_6836_(slotIndex, ItemStack.f_41583_);
                    this.inventory.setQueen(stack);
                } else if (stage == BeeLifeStage.DRONE) {
                    ItemStack drone = this.inventory.getDrone();
                    if (drone.m_41619_()) {
                        this.inventory.setDrone(stack);
                        this.inventory.m_6836_(slotIndex, ItemStack.f_41583_);
                    } else {
                        int free = drone.m_41741_() - drone.m_41613_();
                        if (free > 0 && ItemHandlerHelper.canItemStacksStack((ItemStack)drone, (ItemStack)stack)) {
                            int taken = Math.min(stack.m_41613_(), free);
                            stack.m_41774_(taken);
                            ItemStack newDrone = drone.m_255036_(drone.m_41613_() + taken);
                            this.inventory.setDrone(newDrone);
                        }
                    }
                }
            });
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.refreshUpgrades();
    }

    private void refreshUpgrades() {
        this.energyConsumption = 200 + this.modifier.recalculate((IInventoryAdapter)this.inventory);
        this.beeLogic.setWorkThrottle(Math.max(5, 550 - this.modifier.throttle));
        this.refreshClimate();
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
        if (this.beeLogic.canDoBeeFX()) {
            this.beeLogic.doBeeFX();
        }
    }

    public boolean onPollenRetrieved(IPollen<?> pollen) {
        return this.modifier.sieve && this.inventory.addProduct(pollen.createStack(), false);
    }

    public void onQueenDeath() {
        this.recycleQueen = this.modifier.automated;
        if (this.modifier.fertility > 0) {
            this.spawnAdditionalOffspring();
        }
    }

    private void spawnAdditionalOffspring() {
        int fertility = this.modifier.fertility;
        ArrayList drones = new ArrayList();
        IIndividualHandlerItem.ifPresent((ItemStack)this.inventory.getQueen(), individual -> {
            if (individual instanceof IBee) {
                List offspring;
                IBee queen = (IBee)individual;
                while (drones.size() < fertility && !(offspring = queen.spawnDrones((IBeeHousing)this)).isEmpty()) {
                    drones.addAll(offspring);
                }
            }
        });
        for (int i = 0; i < fertility; ++i) {
            ItemStack stack = ((IBee)drones.get(i)).createStack((ILifeStage)BeeLifeStage.DRONE);
            this.inventory.addProduct(stack, true);
        }
    }

    private void refreshClimate() {
        ClimateState oldClimate = this.modifier.nether ? new ClimateState(TemperatureType.HELLISH, HumidityType.ARID) : IForestryApi.INSTANCE.getClimateManager().createClimateProvider((LevelReader)this.f_58857_, this.f_58858_);
        this.climate = new ClimateState(oldClimate.temperature().up(this.modifier.temperature), oldClimate.humidity().up(this.modifier.humidity));
    }

    public void writeGuiData(FriendlyByteBuf data) {
        this.energyStorage.writeData(data);
        data.m_130130_(this.beeLogic.getBeeProgressPercent());
        NetworkUtil.writeClimateState((FriendlyByteBuf)data, (IClimateProvider)this.climate);
    }

    public void readGuiData(FriendlyByteBuf data) {
        this.energyStorage.readData(data);
        this.breedingProgressPercent = data.m_130242_();
        this.climate = NetworkUtil.readClimateState((FriendlyByteBuf)data);
    }

    public void m_142466_(CompoundTag data) {
        super.m_142466_(data);
        this.energyStorage.read(data);
        this.beeLogic.read(data);
        this.ownerHandler.read(data);
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.energyStorage.write(data);
        this.beeLogic.write(data);
        this.ownerHandler.write(data);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInv, Player player) {
        return new IndustrialApiaryMenu(windowId, playerInv, this);
    }

    public Iterable<IBeeModifier> getBeeModifiers() {
        return Collections.singleton(this.modifier);
    }

    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singleton(this);
    }

    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beeLogic;
    }

    public String getHintKey() {
        return HINTS_KEY;
    }

    public TemperatureType temperature() {
        return this.climate.temperature();
    }

    public HumidityType humidity() {
        return this.climate.humidity();
    }

    public IOwnerHandler getOwnerHandler() {
        return this.ownerHandler;
    }

    public int getBlockLightValue() {
        return this.f_58857_.m_46803_(this.f_58858_.m_7494_());
    }

    public boolean canBlockSeeTheSky() {
        return this.f_58857_.m_45527_(this.f_58858_.m_7494_());
    }

    public boolean isRaining() {
        return this.f_58857_.m_46758_(this.f_58858_.m_7494_());
    }

    @Nullable
    public GameProfile getOwner() {
        return this.ownerHandler.getOwner();
    }

    public Vec3 getBeeFXCoordinates() {
        return this.f_58858_.m_252807_();
    }

    public Holder<Biome> getBiome() {
        return this.f_58857_.m_204166_(this.f_58858_);
    }

    public int getHealthScaled(int pixels) {
        return this.breedingProgressPercent * pixels / 100;
    }

    public ForestryEnergyStorage getEnergyManager() {
        return this.energyStorage;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return !this.f_58859_ && capability == ForgeCapabilities.ENERGY ? this.energyCap.cast() : super.getCapability(capability, facing);
    }
}

