/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.blockentity;

import forestry.api.core.ForestryError;
import forestry.api.core.IError;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.gendustry.blockentity.ProducerBlockEntity;
import thedarkcolour.gendustry.recipe.MutagenRecipe;
import thedarkcolour.gendustry.recipe.cache.MutagenRecipeCache;
import thedarkcolour.gendustry.registry.GBlockEntities;
import thedarkcolour.gendustry.registry.GFluids;

public class MutagenProducerBlockEntity
extends ProducerBlockEntity<MutagenProducerBlockEntity, MutagenRecipe> {
    private static final int ENERGY_PER_WORK_CYCLE = 100000;
    private static final int TICKS_PER_WORK_CYCLE = 200;
    public static final String HINTS_KEY = "gendustry.mutagen_producer";

    public MutagenProducerBlockEntity(BlockPos pos, BlockState state) {
        super(GBlockEntities.MUTAGEN_PRODUCER, GFluids.MUTAGEN, false, pos, state);
    }

    @Override
    public boolean isValidInput(ItemStack input) {
        return MutagenRecipeCache.INSTANCE.getRecipe(input) != null;
    }

    @Override
    @Nullable
    public MutagenRecipe getRecipe(ItemStack input) {
        return MutagenRecipeCache.INSTANCE.getRecipe(input);
    }

    @Override
    public void startWorking() {
        this.setTicksPerWorkCycle(200);
        this.setEnergyPerWorkCycle(100000);
    }

    @Override
    public IError getNoInputError() {
        return ForestryError.NO_RECIPE;
    }

    @Override
    public String getHintsKey() {
        return HINTS_KEY;
    }
}

