/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.compat.jei.producers;

import forestry.api.core.IFeatureSubtype;
import forestry.core.recipes.jei.ForestryRecipeCategory;
import forestry.modules.features.FeatureBlock;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import thedarkcolour.gendustry.block.GendustryMachineType;
import thedarkcolour.gendustry.recipe.ProcessorRecipe;
import thedarkcolour.gendustry.registry.GBlocks;

public abstract class ProducerRecipeCategory<T extends ProcessorRecipe>
extends ForestryRecipeCategory<T> {
    protected static final ResourceLocation GUI = new ResourceLocation("gendustry", "textures/gui/processor.png");
    private final IDrawableAnimated arrow;
    private final IDrawable tankOverlay;
    private final IDrawable icon;

    public ProducerRecipeCategory(IGuiHelper helper, GendustryMachineType type, ItemStack stack) {
        super((IDrawable)helper.createDrawable(GUI, 13, 18, 151, 60), ((FeatureBlock)GBlocks.MACHINE.get((IFeatureSubtype)type)).getTranslationKey());
        IDrawableStatic arrowDrawable = helper.createDrawable(GUI, 176, 60, 55, 18);
        this.arrow = helper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
        this.tankOverlay = helper.createDrawable(GUI, 176, 0, 16, 58);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.arrow.draw(graphics, 35, 23);
    }

    protected void addFluidTank(IRecipeLayoutBuilder builder, Fluid fluid, int amount) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 109, 1).setFluidRenderer(10000L, false, 16, 58).setOverlay(this.tankOverlay, 0, 0).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)new FluidStack(fluid, amount));
    }
}

