/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.recipe;

import com.google.gson.JsonObject;
import forestry.api.IForestryApi;
import forestry.api.genetics.ILifeStage;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.gendustry.recipe.ProcessorRecipe;
import thedarkcolour.gendustry.registry.GRecipeTypes;

public class DnaRecipe
extends ProcessorRecipe {
    private final ISpeciesType<?, ?> speciesType;
    private final ILifeStage stage;

    public DnaRecipe(ResourceLocation id, ISpeciesType<?, ?> speciesType, ILifeStage stage, int amount) {
        super(id, amount);
        this.speciesType = speciesType;
        this.stage = stage;
    }

    public ISpeciesType<?, ?> getSpeciesType() {
        return this.speciesType;
    }

    public ILifeStage getStage() {
        return this.stage;
    }

    public RecipeSerializer<?> m_7707_() {
        return GRecipeTypes.DNA.serializer();
    }

    public RecipeType<?> m_6671_() {
        return GRecipeTypes.DNA.type();
    }

    @Override
    public boolean isIngredient(ItemStack stack) {
        return IIndividualHandlerItem.filter((ItemStack)stack, (i, stage) -> stage == this.stage);
    }

    public static class Serializer
    implements RecipeSerializer<DnaRecipe> {
        public DnaRecipe fromJson(ResourceLocation id, JsonObject json) {
            ResourceLocation speciesTypeId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"species_type"));
            String stageName = GsonHelper.m_13906_((JsonObject)json, (String)"stage");
            int amount = GsonHelper.m_13927_((JsonObject)json, (String)"amount");
            ISpeciesType speciesType = IForestryApi.INSTANCE.getGeneticManager().getSpeciesType(speciesTypeId);
            ILifeStage stage = null;
            for (ILifeStage s : speciesType.getLifeStages()) {
                if (!s.m_7912_().equals(stageName)) continue;
                stage = s;
                break;
            }
            if (stage == null) {
                throw new IllegalStateException("No such life stage " + stageName + " for species type " + speciesTypeId);
            }
            return new DnaRecipe(id, speciesType, stage, amount);
        }

        @Nullable
        public DnaRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf data) {
            ISpeciesType speciesType = IForestryApi.INSTANCE.getGeneticManager().getSpeciesType(data.m_130281_());
            ILifeStage stage = null;
            String stageName = data.m_130277_();
            for (ILifeStage s : speciesType.getLifeStages()) {
                if (!s.m_7912_().equals(stageName)) continue;
                stage = s;
                break;
            }
            if (stage == null) {
                return null;
            }
            short amount = data.readShort();
            return new DnaRecipe(id, speciesType, stage, amount);
        }

        public void toNetwork(FriendlyByteBuf data, DnaRecipe recipe) {
            data.m_130085_(recipe.speciesType.id());
            data.m_130070_(recipe.stage.m_7912_());
            data.writeShort(recipe.amount);
        }
    }
}

