/*
 * Decompiled with CFR 0.152.
 */
package thedarkcolour.gendustry.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;
import thedarkcolour.gendustry.recipe.ProcessorRecipe;
import thedarkcolour.gendustry.registry.GRecipeTypes;

public class MutagenRecipe
extends ProcessorRecipe {
    private final Ingredient ingredient;

    public MutagenRecipe(ResourceLocation id, Ingredient ingredient, int amount) {
        super(id, amount);
        this.ingredient = ingredient;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public boolean isIngredient(ItemStack stack) {
        return this.ingredient.test(stack);
    }

    public RecipeSerializer<?> m_7707_() {
        return GRecipeTypes.MUTAGEN.serializer();
    }

    public RecipeType<?> m_6671_() {
        return GRecipeTypes.MUTAGEN.type();
    }

    public static class Serializer
    implements RecipeSerializer<MutagenRecipe> {
        public MutagenRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient ingredient = Ingredient.m_43917_((JsonElement)json.get("ingredient"));
            int amount = GsonHelper.m_13927_((JsonObject)json, (String)"amount");
            return new MutagenRecipe(id, ingredient, amount);
        }

        @Nullable
        public MutagenRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf data) {
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)data);
            short amount = data.readShort();
            return new MutagenRecipe(id, ingredient, amount);
        }

        public void toNetwork(FriendlyByteBuf data, MutagenRecipe recipe) {
            recipe.ingredient.m_43923_(data);
            data.writeShort(recipe.amount);
        }
    }
}

